---
navigation:
  parent: items-blocks-machines/items-blocks-machines-index.md
  title: Processors
  icon: logic_processor
  position: 010
categories:
- misc ingredients blocks
item_ids:
- ae2:logic_processor
- ae2:calculation_processor
- ae2:engineering_processor
- ae2:printed_silicon
- ae2:printed_logic_processor
- ae2:printed_calculation_processor
- ae2:printed_engineering_processor
- ae2:silicon
---

# Processors

<Row>
  <ItemImage id="logic_processor" scale="4" />

  <ItemImage id="calculation_processor" scale="4" />

  <ItemImage id="engineering_processor" scale="4" />
</Row>

Processors are one of the primary ingredients in AE2 [devices](../ae2-mechanics/devices.md) and machines. They represent one of your first big automation challenges, as nearly every part of AE2 depends on them.

There are three types of processor:  
- **Logic Processor** (crafted with gold)  
- **Calculation Processor** (crafted with <ItemLink id="certus_quartz_crystal" />)  
- **Engineering Processor** (crafted with diamond)  

## Crafting in this Pack

In the default AE2 experience, processors are made using [presses](presses.md) and an <ItemLink id="inscriber" /> in multiple steps.  

In this pack, however, **presses and inscribers are not used**. All processor crafting has been streamlined into the **Circuit Fabricator multiblock**.  
This structure handles the full processor production pipeline, from “printed” components to final processors, without requiring presses.

## Requirements

- The **Circuit Fabricator** must be constructed and active.  
- A <ItemLink id="mysterious_cube" /> is required for the multiblock to function.  
- Recipes are viewable in-game through **JEI**, and will show the inputs required for each processor type.

