// priority: 50

removeRecipe.push(
  "oirtech:mixing/compat/create/goldgem",
  "oritech:atomicforge/dust/copper",
  "oritech:atomicforge/dust/gold",
  "oritech:atomicforge/dust/iron",
  "oritech:atomicforge/dust/nickel",
  "oritech:atomicforge/dust/platinum",
  "oritech:blasting/compat/create/crushed_nickel_to_nickel_ingot",
  "oritech:blasting/compat/create/crushed_platinum_to_platinum_ingot",
  "oritech:centrifuge/clump/copper",
  "oritech:centrifuge/clump/gold",
  "oritech:centrifuge/clump/iron",
  "oritech:centrifuge/clump/nickel",
  "oritech:centrifuge/clump/platinum",
  "oritech:centrifuge/compat/clump/crushed_uranium",
  "oritech:centrifuge/compat/create/clump/zinc",
  "oritech:centrifuge/compat/mekanism/clump/lead",
  "oritech:centrifuge/compat/mekanism/clump/osmium",
  "oritech:centrifuge/compat/mekanism/clump/tin",
  "oritech:centrifuge/fluid/clump/copper",
  "oritech:centrifuge/fluid/clump/gold",
  "oritech:centrifuge/fluid/clump/iron",
  "oritech:centrifuge/fluid/clump/nickel",
  "oritech:centrifuge/fluid/clump/platinum",
  "oritech:centrifuge/fluid/compat/clumpwet/crushed_uranium",
  "oritech:centrifuge/fluid/compat/create/clump/zinc",
  "oritech:centrifuge/fluid/compat/create/clumpacid/zinc",
  "oritech:centrifuge/fluid/compat/immersiveengineering/clumpacid/lead",
  "oritech:centrifuge/fluid/compat/mekanism/clump/lead",
  "oritech:centrifuge/fluid/compat/mekanism/clump/osmium",
  "oritech:centrifuge/fluid/compat/mekanism/clump/tin",
  "oritech:centrifuge/fluid/compat/mekanism/clumpacid/lead",
  "oritech:centrifuge/fluid/compat/mekanism/clumpacid/osmium",
  "oritech:centrifuge/fluid/compat/mekanism/clumpacid/tin",
  "oritech:compat/alloyforgery/electrum",
  "oritech:compat/immersiveengineering/alloying/coppergem",
  "oritech:compat/immersiveengineering/alloying/electrum",
  "oritech:compat/immersiveengineering/alloying/goldgem",
  "oritech:compat/immersiveengineering/alloying/irongem",
  "oritech:compat/immersiveengineering/alloying/nickelgem",
  "oritech:compat/immersiveengineering/alloying/platinumgem",
  "oritech:compat/immersiveengineering/arcalloying/coppergem",
  "oritech:compat/immersiveengineering/arcalloying/electrum",
  "oritech:compat/immersiveengineering/arcalloying/goldgem",
  "oritech:compat/immersiveengineering/arcalloying/irongem",
  "oritech:compat/immersiveengineering/arcalloying/nickelgem",
  "oritech:compat/immersiveengineering/arcalloying/platinumgem",
  "oritech:compat/mekanism/infusing/electrum_dust",
  "oritech:compat/productivemetalworks/casting/block/duratium",
  "oritech:compat/productivemetalworks/casting/block/nickel",
  "oritech:compat/productivemetalworks/casting/block/platinum",
  "oritech:compat/productivemetalworks/casting/block/steel",
  "oritech:compat/productivemetalworks/casting/ingot/electrum",
  "oritech:compat/productivemetalworks/casting/ingot/nickel",
  "oritech:compat/productivemetalworks/casting/ingot/platinum",
  "oritech:compat/productivemetalworks/casting/ingot/steel",
  "oritech:compat/productivemetalworks/casting/nugget/nickel",
  "oritech:compat/productivemetalworks/casting/nugget/platinum",
  "oritech:compat/productivemetalworks/melting/clump/copper",
  "oritech:compat/productivemetalworks/melting/clump/gold",
  "oritech:compat/productivemetalworks/melting/clump/iron",
  "oritech:compat/productivemetalworks/melting/clump/nickel",
  "oritech:compat/productivemetalworks/melting/clump/platinum",
  "oritech:compat/productivemetalworks/melting/gem/copper",
  "oritech:compat/productivemetalworks/melting/gem/gold",
  "oritech:compat/productivemetalworks/melting/gem/iron",
  "oritech:compat/productivemetalworks/melting/gem/nickel",
  "oritech:compat/productivemetalworks/melting/gem/platinum",
  "oritech:compat/productivemetalworks/melting/smallclump/copper",
  "oritech:compat/productivemetalworks/melting/smallclump/gold",
  "oritech:compat/productivemetalworks/melting/smallclump/iron",
  "oritech:compat/productivemetalworks/melting/smallclump/nickel",
  "oritech:compat/productivemetalworks/melting/smallclump/platinum",
  "oritech:compat/productivemetalworks/melting/smalldust/copper",
  "oritech:compat/productivemetalworks/melting/smalldust/gold",
  "oritech:compat/productivemetalworks/melting/smalldust/iron",
  "oritech:compat/productivemetalworks/melting/smalldust/nickel",
  "oritech:compat/productivemetalworks/melting/smalldust/platinum",
  "oritech:copper_clump",
  "oritech:copper_dust",
  "oritech:copper_dust",
  "oritech:copper_ingot_from_blasting_copper_dust",
  "oritech:copper_ingot_from_blasting_copper_gem",
  "oritech:copper_ingot_from_smelting_copper_dust",
  "oritech:copper_ingot_from_smelting_copper_gem",
  "oritech:copper_nugget_from_blasting_small_copper_dust",
  "oritech:copper_nugget_from_smelting_small_copper_dust",
  "oritech:copper_nugget_from_smelting_small_copper_dusts",
  "oritech:crafting/alloy/electrum",
  "oritech:crafting/alloy/steel",
  "oritech:crushing/compat/create/copperingot",
  "oritech:crushing/compat/create/goldingot",
  "oritech:crushing/compat/create/ironingot",
  "oritech:crushing/compat/create/nickelingot",
  "oritech:crushing/compat/create/platinumingot",
  "oritech:electrum_blockblock",
  "oritech:electrum_blockblockinv",
  "oritech:electrum_ingot_from_blasting_electrum_dust",
  "oritech:electrum_ingot_from_smelting_electrum_dust",
  "oritech:foundry/alloy/compat/create/brass",
  "oritech:foundry/alloy/compat/immersiveengineering/constantan",
  "oritech:foundry/alloy/compat/mekanism/atomic_alloy",
  "oritech:foundry/alloy/compat/mekanism/bronze",
  "oritech:foundry/alloy/compat/mekanism/infused_alloy",
  "oritech:foundry/alloy/compat/mekanism/refined_obsidian_dust",
  "oritech:foundry/alloy/compat/mekanism/reinforced_alloy",
  "oritech:foundry/alloy/electrum",
  "oritech:foundry/alloy/gem/copper",
  "oritech:foundry/alloy/gem/gold",
  "oritech:foundry/alloy/gem/gold",
  "oritech:foundry/alloy/gem/iron",
  "oritech:foundry/alloy/gem/nickel",
  "oritech:foundry/alloy/gem/platinum",
  "oritech:gold_clump",
  "oritech:gold_dust",
  "oritech:gold_dust",
  "oritech:gold_ingot_from_blasting_gold_dust",
  "oritech:gold_ingot_from_blasting_gold_gem",
  "oritech:gold_ingot_from_smelting_gold_dust",
  "oritech:gold_ingot_from_smelting_gold_gem",
  "oritech:gold_nugget_from_blasting_small_gold_dust",
  "oritech:gold_nugget_from_smelting_small_gold_dust",
  "oritech:grinder/biobasic",
  "oritech:grinder/coal",
  "oritech:grinder/coalore",
  "oritech:grinder/compat/create/ore/zinc",
  "oritech:grinder/compat/create/raw/zinc",
  "oritech:grinder/compat/immersiveengineering/dust/aluminum",
  "oritech:grinder/compat/immersiveengineering/dust/lead",
  "oritech:grinder/compat/immersiveengineering/dust/silver",
  "oritech:grinder/compat/immersiveengineering/ore/aluminum",
  "oritech:grinder/compat/immersiveengineering/ore/lead",
  "oritech:grinder/compat/immersiveengineering/ore/silver",
  "oritech:grinder/compat/immersiveengineering/raw/aluminum",
  "oritech:grinder/compat/immersiveengineering/raw/lead",
  "oritech:grinder/compat/immersiveengineering/raw/silver",
  "oritech:grinder/compat/mekanism/dust/bronze",
  "oritech:grinder/compat/mekanism/dust/charcoal",
  "oritech:grinder/compat/mekanism/dust/diamond",
  "oritech:grinder/compat/mekanism/dust/emerald",
  "oritech:grinder/compat/mekanism/dust/fluorite",
  "oritech:grinder/compat/mekanism/dust/lapis",
  "oritech:grinder/compat/mekanism/dust/lead",
  "oritech:grinder/compat/mekanism/dust/netherite",
  "oritech:grinder/compat/mekanism/dust/obsidian",
  "oritech:grinder/compat/mekanism/dust/osmium",
  "oritech:grinder/compat/mekanism/dust/refined_obsidian",
  "oritech:grinder/compat/mekanism/dust/steel",
  "oritech:grinder/compat/mekanism/dust/tin",
  "oritech:grinder/compat/mekanism/ore/lead",
  "oritech:grinder/compat/mekanism/ore/osmium",
  "oritech:grinder/compat/mekanism/ore/tin",
  "oritech:grinder/compat/mekanism/raw/lead",
  "oritech:grinder/compat/mekanism/raw/osmium",
  "oritech:grinder/compat/mekanism/raw/tin",
  "oritech:grinder/diamondore",
  "oritech:grinder/duratium",
  "oritech:grinder/dust/copper",
  "oritech:grinder/dust/copper",
  "oritech:grinder/dust/gold",
  "oritech:grinder/dust/gold",
  "oritech:grinder/dust/iron",
  "oritech:grinder/dust/iron",
  "oritech:grinder/dust/nickel",
  "oritech:grinder/dust/nickel",
  "oritech:grinder/dust/platinum",
  "oritech:grinder/dust/platinum",
  "oritech:grinder/electrum",
  "oritech:grinder/lapisore",
  "oritech:grinder/ore/copper",
  "oritech:grinder/ore/gold",
  "oritech:grinder/ore/iron",
  "oritech:grinder/ore/nickel",
  "oritech:grinder/ore/platinum",
  "oritech:grinder/quartz",
  "oritech:grinder/raw/copper",
  "oritech:grinder/raw/gold",
  "oritech:grinder/raw/iron",
  "oritech:grinder/raw/nickel",
  "oritech:grinder/raw/platinum",
  "oritech:grinder/redstoneore",
  "oritech:grinder/smalldust/copper",
  "oritech:grinder/smalldust/gold",
  "oritech:grinder/smalldust/iron",
  "oritech:grinder/smalldust/nickel",
  "oritech:grinder/smalldust/platinum",
  "oritech:grinder/uranium",
  "oritech:grinder/uraniumcrystal",
  "oritech:grinder/uraniumore",
  "oritech:iron_clump",
  "oritech:iron_dust",
  "oritech:iron_ingot_from_blasting_iron_dust",
  "oritech:iron_ingot_from_blasting_iron_dust",
  "oritech:iron_ingot_from_blasting_iron_gem",
  "oritech:iron_ingot_from_smelting_iron_dust",
  "oritech:iron_ingot_from_smelting_iron_gem",
  "oritech:iron_nugget_from_blasting_small_iron_dust",
  "oritech:iron_nugget_from_blasting_small_iron_dust",
  "oritech:iron_nugget_from_smelting_small_iron_dust",
  "oritech:mixing/compat/create/coppergem",
  "oritech:mixing/compat/create/electrum",
  "oritech:mixing/compat/create/goldgem",
  "oritech:mixing/compat/create/irongem",
  "oritech:mixing/compat/create/nickelgem",
  "oritech:mixing/compat/create/platinumgem",
  "oritech:nickel_blockblock",
  "oritech:nickel_blockblockinv",
  "oritech:nickel_clump",
  "oritech:nickel_dust",
  "oritech:nickel_ingot_from_blasting_nickel_dust",
  "oritech:nickel_ingot_from_blasting_nickel_gem",
  "oritech:nickel_ingot_from_blasting_raw_nickel",
  "oritech:nickel_ingot_from_smelting_nickel_dust",
  "oritech:nickel_ingot_from_smelting_nickel_gem",
  "oritech:nickel_ingot_from_smelting_raw_nickel",
  "oritech:nickel_ingot",
  "oritech:nickel_nugget_from_blasting_small_nickel_dust",
  "oritech:nickel_nugget_from_smelting_small_nickel_dust",
  "oritech:platinum_blockblock",
  "oritech:platinum_blockblockinv",
  "oritech:platinum_clump",
  "oritech:platinum_dust",
  "oritech:platinum_ingot_from_blasting_platinum_dust",
  "oritech:platinum_ingot_from_blasting_platinum_gem",
  "oritech:platinum_ingot_from_blasting_raw_platinum",
  "oritech:platinum_ingot_from_smelting_platinum_dust",
  "oritech:platinum_ingot_from_smelting_platinum_gem",
  "oritech:platinum_ingot_from_smelting_raw_platinum",
  "oritech:platinum_ingot",
  "oritech:platinum_nugget_from_blasting_small_platinum_dust",
  "oritech:platinum_nugget_from_smelting_small_platinum_dust",
  "oritech:plutonium_dustblock",
  "oritech:plutonium_dustblockinv",
  "oritech:pulverizer/coal",
  "oritech:pulverizer/coalore",
  "oritech:pulverizer/compat/create/ore/zinc",
  "oritech:pulverizer/compat/immersiveengineering/dust/aluminum",
  "oritech:pulverizer/compat/immersiveengineering/dust/lead",
  "oritech:pulverizer/compat/immersiveengineering/dust/silver",
  "oritech:pulverizer/compat/immersiveengineering/ore/aluminum",
  "oritech:pulverizer/compat/immersiveengineering/ore/lead",
  "oritech:pulverizer/compat/immersiveengineering/ore/silver",
  "oritech:pulverizer/compat/immersiveengineering/raw/aluminum",
  "oritech:pulverizer/compat/immersiveengineering/raw/lead",
  "oritech:pulverizer/compat/immersiveengineering/raw/silver",
  "oritech:pulverizer/compat/mekanism/dust/bronze",
  "oritech:pulverizer/compat/mekanism/dust/charcoal",
  "oritech:pulverizer/compat/mekanism/dust/diamond",
  "oritech:pulverizer/compat/mekanism/dust/emerald",
  "oritech:pulverizer/compat/mekanism/dust/fluorite",
  "oritech:pulverizer/compat/mekanism/dust/lapis",
  "oritech:pulverizer/compat/mekanism/dust/lead",
  "oritech:pulverizer/compat/mekanism/dust/netherite",
  "oritech:pulverizer/compat/mekanism/dust/obsidian",
  "oritech:pulverizer/compat/mekanism/dust/osmium",
  "oritech:pulverizer/compat/mekanism/dust/refined_obsidian",
  "oritech:pulverizer/compat/mekanism/dust/steel",
  "oritech:pulverizer/compat/mekanism/dust/tin",
  "oritech:pulverizer/compat/mekanism/ore/lead",
  "oritech:pulverizer/compat/mekanism/ore/osmium",
  "oritech:pulverizer/compat/mekanism/ore/tin",
  "oritech:pulverizer/compat/mekanism/raw/lead",
  "oritech:pulverizer/compat/mekanism/raw/osmium",
  "oritech:pulverizer/compat/mekanism/raw/tin",
  "oritech:pulverizer/diamondore",
  "oritech:pulverizer/dust/copper",
  "oritech:pulverizer/dust/gold",
  "oritech:pulverizer/dust/iron",
  "oritech:pulverizer/dust/nickel",
  "oritech:pulverizer/dust/platinum",
  "oritech:pulverizer/dyes/blue",
  "oritech:pulverizer/electrum",
  "oritech:pulverizer/glowstoneore",
  "oritech:pulverizer/lapisore",
  "oritech:pulverizer/ore/nickel",
  "oritech:pulverizer/ore/platinum",
  "oritech:pulverizer/quartz",
  "oritech:pulverizer/raw/copper",
  "oritech:pulverizer/raw/gold",
  "oritech:pulverizer/raw/iron",
  "oritech:pulverizer/raw/nickel",
  "oritech:pulverizer/raw/platinum",
  "oritech:pulverizer/redstoneore",
  "oritech:pulverizer/smalldust/copper",
  "oritech:pulverizer/smalldust/gold",
  "oritech:pulverizer/smalldust/iron",
  "oritech:pulverizer/smalldust/nickel",
  "oritech:pulverizer/smalldust/platinum",
  "oritech:pulverizer/steel",
  "oritech:pulverizer/uranium",
  "oritech:pulverizer/uraniumore",
  "oritech:raw_nickel_blockblock",
  "oritech:raw_nickel_blockblockinv",
  "oritech:raw_platinum_blockblock",
  "oritech:raw_platinum_blockblockinv",
  "oritech:refinery/compat/immersiveengineering/rawsheol/aluminum",
  "oritech:refinery/compat/immersiveengineering/rawsheol/lead",
  "oritech:refinery/compat/mekanism/rawsheol/lead",
  "oritech:refinery/compat/mekanism/rawsheol/osmium",
  "oritech:refinery/compat/mekanism/rawsheol/tin",
  "oritech:refinery/rawsheol/copper",
  "oritech:refinery/rawsheol/gold",
  "oritech:refinery/rawsheol/iron",
  "oritech:refinery/rawsheol/nickel",
  "oritech:refinery/rawsheol/platinum",
  "oritech:silicon_blockblock",
  "oritech:silicon_blockblockinv",
  "oritech:splashing/compat/create/copperclump",
  "oritech:splashing/compat/create/goldclump",
  "oritech:splashing/compat/create/ironclump",
  "oritech:splashing/compat/create/nickelclump",
  "oritech:splashing/compat/create/platinumclump",
  "oritech:splashing/compat/create/redstone",
  "oritech:splashing/compat/create/uraniumclump",
  "oritech:steel_blockblock",
  "oritech:steel_blockblockinv",
  "oritech:steel_ingot_from_blasting_steel_dust",
  "oritech:steel_ingot_from_smelting_steel_dust",
  "oritech:uranium_dustblock",
  "oritech:uranium_dustblockinv",
  "oritech:crafting/centrifuge",
  "oritech:compat/productivemetalworks/casting/block/electrum"
)

removeOre.push(
  "oritech:nickel_ore",
  "oritech:deepslate_nickel_ore",
  "oritech:deepslate_platinum_ore",
  "oritech:deepslate_uranium_ore",
  "oritech:endstone_platinum_ore"
)

removeItem.push(
  "oritech:copper_clump",
  "oritech:copper_dust",
  "oritech:gold_clump",
  "oritech:gold_dust",
  "oritech:iron_clump",
  "oritech:iron_dust",
  "oritech:nickel_clump",
  "oritech:nickel_dust",
  "oritech:platinum_clump",
  "oritech:platinum_dust",
  "oritech:raw_nickel_block",
  "oritech:raw_nickel",
  "oritech:raw_platinum_block",
  "oritech:raw_platinum",
  "oritech:raw_uranium",
  "oritech:small_copper_clump",
  "oritech:small_gold_clump",
  "oritech:small_iron_clump",
  "oritech:small_nickel_clump",
  "oritech:small_platinum_clump",
  "oritech:nickel_gem",
  "oritech:platinum_gem",
  "oritech:iron_gem",
  "oritech:copper_gem",
  "oritech:gold_gem",
  "oritech:uranium_dust",
  "oritech:silicon",
  "oritech:silicon_block",
  "oritech:steel_ingot",
  "oritech:steel_block",
  "oritech:steel_dust",
  "oritech:coal_dust",
  "oritech:platinum_block",
  "oritech:nickel_block",
  "oritech:electrum_block",
  "oritech:nickel_nugget",
  "oritech:platinum_nugget",
  "oritech:copper_nugget",
  "oritech:plutonium_dust",
  "oritech:electrum_dust",
  "oritech:quartz_dust",
  "oritech:nickel_ingot",
  "oritech:platinum_ingot",
  "oritech:electrum_ingot",
  "oritech:still_sulfuric_acid_bucket",
  "oritech:still_steam_bucket",
  "oritech:biomass_block",
  "oritech:biomass",
  "oritech:plastic_sheet",
  "oritech:still_sulfuric_acid_bucket",
  "oritech:still_oil_bucket",
  "oritech:still_diesel_bucket",
  "oritech:still_naphtha_bucket",
  "oritech:still_steam_bucket",
  "oritech:small_nickel_dust",
  "oritech:small_platinum_dust",
  "oritech:small_iron_dust",
  "oritech:small_copper_dust",
  "oritech:small_gold_dust",
  "oritech:small_uranium_dust",
  "oritech:small_plutonium_dust"
)

//Mekanism adds its own Sulfuric Acid, so oritech recipes should be unified with it.
if (Platform.isLoaded("mekanism")) {
  remFluid.push(
    "oritech:still_sulfuric_acid",
    "oritech:flowing_sulfuric_acid",
    "oritech:still_biofuel",
    "oritech:flowing_biofuel"
  )
}

removeItemTag.push([`c:ingots/steel`, `oritech:biosteel_ingot`])

ServerEvents.recipes((event) => {
  global.resourceOresIngots.forEach((mod) => {
    mod.materials.forEach((material) => {
      const rawMaterialTag = `${global.tagPrefix}:raw_materials/${material}`
      const oreTag = `${global.tagPrefix}:ores/${material}`
      const clumpTag = `c:clumps/${material}`
      const clump = `ftbmaterials:${material}_clump`
      const dust = `ftbmaterials:${material}_dust`
      const tiny_dust = `ftbmaterials:${material}_tiny_dust`
      const nugget =
        material === "copper"
          ? "ftbmaterials:copper_nugget"
          : ["iron", "gold"].includes(material)
          ? `minecraft:${material}_nugget`
          : `ftbmaterials:${material}_nugget`
      const result = getSecondaryOutput(material)
      const oritechSecondaryOutput = nugget
      if (global.enableTinyDust) {
        oritechSecondaryOutput = tiny_dust
      }
      // Raw Ore -> {Clump, Tiny Dust / Nugget}
      addRecipeOritechGrinder(
        event,
        rawMaterialTag,
        [[clump], [oritechSecondaryOutput, 3]],
        `ftb:oritech/fragmenting/raw_materials/${material}`
      )

      // Ore -> {Raw Ore, Secondary Raw Ore}
      addRecipeOritechGrinder(
        event,
        oreTag,
        [
          [getRawOreId(material), 2],
          [getRawOreId(result.material), result.amount]
        ],
        `ftb:oritech/fragmenting/ore/${material}`
      )

      // Clump -> {Dust}
      addRecipeOritechCentrifugeFluid(
        event,
        clumpTag,
        [[dust, 2]],
        ["minecraft:water", 1000],
        `ftb:oritech/centrifuge/fluid/clump/${material}`
      )

      // Clump -> {Dust, Tiny Dust / Nugget}
      addRecipeOritechCentrifugeItem(
        event,
        clumpTag,
        [
          [dust, 1],
          [oritechSecondaryOutput, 3]
        ],
        `ftb:oritech/centrifuge/clump/${material}`
      )

      // Clump -> {Dirty Dust}
      addRecipeOritechAtomicForge(
        event,
        [`ftbmaterials:${material}_clump`, "oritech:fluxite", "oritech:fluxite"],
        [[`ftbmaterials:${material}_dirty_dust`, 2]],
        `ftb:oritech/atomicforge/clump/${material}`
      )

      // Dirty Dust -> {Dust}
      addRecipeOritechCentrifugeFluid(
        event,
        `c:dirty_dusts/${material}`,
        [[dust, 2]],
        ["minecraft:water", 1000],
        `ftb:oritech/centrifuge/fluid/dirty_dusts/${material}`
      )

      // Raw Ore -> {Dust, Tiny Dust / Nugget}
      addRecipeOritechPulverizer(
        event,
        rawMaterialTag,
        [[dust], [oritechSecondaryOutput, 3]],
        `ftb:oritech/pulverizer/raw/${material}`
      )

      // Ingots -> {Dust}
      addRecipeOritechPulverizer(event, `c:ingots/${material}`, [[dust]], `ftb:oritech/pulverizer/ingots/${material}`)

      // Raw -> {3x Clumps}
      addRecipeOritechRefinery(
        event,
        rawMaterialTag,
        [[clump, 3]],
        ["minecraft:lava", 200],
        ["oritech:still_sheol_fire", 250],
        `ftb:oritech/refinery/${material}`
      )
    })
  })

  // Loop For Gem Ores
  global.resourcesOresGem.forEach((mod) => {
    mod.materials.forEach((material) => {
      const gemType = material[0]
      let oreTag = `${global.tagPrefix}:ores/${gemType}`
      if (oreTag === "c:ores/lapis_lazuli") {
        oreTag = "c:ores/lapis"
      }
      const outputId = material[2] ?? `${mod.modID}:${gemType}`
      const outputAmount = material[1] ?? 1

      addRecipeOritechPulverizer(
        event,
        oreTag,
        [
          [outputId, outputAmount],
          [outputId, Math.max(1, Math.floor(outputAmount / 2)), 0.33]
        ],
        `ftb:oritech/pulverizer/ore/${gemType}`
      )

      // Gem -> Dust
      if (material[3] !== false) {
        if (Item.exists(`ftbmaterials:${gemType}_dust`)) {
          addRecipeOritechPulverizer(
            event,
            outputId,
            [[`ftbmaterials:${gemType}_dust`, 1]],
            `ftb:oritech/pulverizer/gem/${gemType}`
          )
        }
      }
    })
  })

  global.enabledAlloys.forEach((material) => {
    const outputType = material.output.id
    const outputAmount = material.output.amount ?? 1
    const input1Type = material.first.id
    const input1Amount = material.first.amount ?? 1
    const input2Type = material.second.id
    const input2Amount = material.second.amount ?? 1

    addRecipeOritechFoundry(
      event,
      [
        [`c:ingots/${input1Type}`, input1Amount],
        [`c:ingots/${input2Type}`, input2Amount]
      ],
      [[`ftbmaterials:${outputType}_ingot`, outputAmount]],
      `ftb:oritech/foundry/${outputType}`
    )
  })

  addRecipeOritechFoundry(
    event,
    [
      [`c:clay`, 1],
      [`c:dusts/glowstone`, 1]
    ],
    [[`enderio:clayed_glowstone`, 2]],
    `ftb:oritech/foundry/clayed_glowstone`
  )

  addRecipeOritechPulverizer(
    event,
    "minecraft:coal",
    [[`ftbmaterials:coal_dust`, 1]],
    `ftb:oritech/pulverizer/gem/coal`
  )
})
