/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.noexception;

import com.machinezoo.noexception.CheckedExceptionHandler;
import com.machinezoo.noexception.ExceptionHandler;
import com.machinezoo.noexception.IgnoringHandler;
import com.machinezoo.noexception.LoggingHandler;
import com.machinezoo.noexception.MappingHandler;
import com.machinezoo.noexception.SilencingHandler;
import com.machinezoo.noexception.SneakingHandler;
import com.machinezoo.noexception.WrappingHandler;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Exceptions {
    private static final Logger logger = LoggerFactory.getLogger(Exceptions.class);
    private static final IgnoringHandler ignore = new IgnoringHandler();
    private static final LoggingHandler log = new LoggingHandler(logger, () -> "Caught exception.");
    private static final SilencingHandler silence = new SilencingHandler();
    private static final SneakingHandler sneak = new SneakingHandler();
    private static final WrappingHandler wrap = new WrappingHandler();

    private Exceptions() {
    }

    public static ExceptionHandler ignore() {
        return ignore;
    }

    @Deprecated
    public static ExceptionHandler pass() {
        return Exceptions.ignore();
    }

    public static ExceptionHandler log() {
        return log;
    }

    public static ExceptionHandler log(Logger logger) {
        return new LoggingHandler(logger, () -> "Caught exception.");
    }

    public static ExceptionHandler log(Logger logger, String message) {
        Objects.requireNonNull(message);
        return new LoggingHandler(logger, () -> message);
    }

    public static ExceptionHandler log(Logger logger, Supplier<String> message) {
        return new LoggingHandler(logger, message);
    }

    public static ExceptionHandler silence() {
        return silence;
    }

    public static CheckedExceptionHandler sneak() {
        return sneak;
    }

    public static CheckedExceptionHandler wrap() {
        return wrap;
    }

    public static CheckedExceptionHandler wrap(Function<Exception, RuntimeException> wrapper) {
        return new MappingHandler(wrapper);
    }
}

