/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import java.lang.reflect.Field;
import java.security.CodeSigner;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarInputStream;
import sun.misc.Unsafe;

public class SecureJarVerifier {
    private static final boolean USE_UNSAAFE = Boolean.parseBoolean(System.getProperty("securejarhandler.useUnsafeAccessor", "true"));
    private static IAccessor ACCESSOR = USE_UNSAAFE ? new UnsafeAccessor() : new Reflection();
    private static final char[] LOOKUP = "0123456789abcdef".toCharArray();

    public static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(2 * bytes.length);
        int bytesLength = bytes.length;
        for (int i = 0; i < bytesLength; ++i) {
            int aByte = bytes[i] & 0xFF;
            buffer.append(LOOKUP[(aByte & 0xF0) >> 4]);
            buffer.append(LOOKUP[aByte & 0xF]);
        }
        return buffer.toString();
    }

    public static boolean isSigningRelated(String path) {
        String filename = path.toLowerCase(Locale.ENGLISH);
        if (!filename.startsWith("meta-inf/")) {
            return false;
        }
        if ((filename = filename.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if ("manifest.mf".equals(filename) || filename.endsWith(".sf") || filename.endsWith(".dsa") || filename.endsWith(".rsa")) {
            return true;
        }
        if (!filename.startsWith("sig-")) {
            return false;
        }
        int ext = filename.lastIndexOf(46);
        if (ext == -1) {
            return true;
        }
        if (ext < filename.length() - 4) {
            return false;
        }
        for (int x = ext + 1; x < filename.length(); ++x) {
            char c = filename.charAt(x);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static Object getJarVerifier(Object inst) {
        return ACCESSOR.getJarVerifier(inst);
    }

    public static boolean isParsingMeta(Object inst) {
        return ACCESSOR.isParsingMeta(inst);
    }

    public static boolean hasSignatures(Object inst) {
        return ACCESSOR.hasSignatures(inst);
    }

    public static Map<String, CodeSigner[]> getVerifiedSigners(Object inst) {
        return ACCESSOR.getVerifiedSigners(inst);
    }

    public static Map<String, CodeSigner[]> getPendingSigners(Object inst) {
        return ACCESSOR.getPendingSigners(inst);
    }

    private static interface IAccessor {
        public Object getJarVerifier(Object var1);

        public boolean isParsingMeta(Object var1);

        public boolean hasSignatures(Object var1);

        public Map<String, CodeSigner[]> getVerifiedSigners(Object var1);

        public Map<String, CodeSigner[]> getPendingSigners(Object var1);
    }

    private static class UnsafeAccessor
    implements IAccessor {
        private static final Unsafe UNSAFE;
        private static final Class<?> JV_TYPE;
        private static final long jarVerifier;
        private static final long sigFileSigners;
        private static final long verifiedSigners;
        private static final long parsingMeta;
        private static final long anyToVerify;

        private UnsafeAccessor() {
        }

        private static long getOffset(Class<?> clz, String name) {
            try {
                return UNSAFE.objectFieldOffset(clz.getDeclaredField(name));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get index for " + clz.getName() + "." + name + ",  be sure to report this will exact details on what JVM you're running.", e);
            }
        }

        @Override
        public Object getJarVerifier(Object inst) {
            return UNSAFE.getObject(inst, jarVerifier);
        }

        @Override
        public boolean isParsingMeta(Object inst) {
            return UNSAFE.getBoolean(inst, parsingMeta);
        }

        @Override
        public boolean hasSignatures(Object inst) {
            return UNSAFE.getBoolean(inst, anyToVerify);
        }

        @Override
        public Map<String, CodeSigner[]> getVerifiedSigners(Object inst) {
            return (Map)UNSAFE.getObject(inst, verifiedSigners);
        }

        @Override
        public Map<String, CodeSigner[]> getPendingSigners(Object inst) {
            return (Map)UNSAFE.getObject(inst, sigFileSigners);
        }

        static {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                UNSAFE = (Unsafe)f.get(null);
                JV_TYPE = JarInputStream.class.getDeclaredField("jv").getType();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get Unsafe reference, this should never be possible, be sure to report this will exact details on what JVM you're running.", e);
            }
            jarVerifier = UnsafeAccessor.getOffset(JarInputStream.class, "jv");
            sigFileSigners = UnsafeAccessor.getOffset(JV_TYPE, "sigFileSigners");
            verifiedSigners = UnsafeAccessor.getOffset(JV_TYPE, "verifiedSigners");
            parsingMeta = UnsafeAccessor.getOffset(JV_TYPE, "parsingMeta");
            anyToVerify = UnsafeAccessor.getOffset(JV_TYPE, "anyToVerify");
        }
    }

    private static class Reflection
    implements IAccessor {
        private static final Field jarVerifier;
        private static final Field parsingMeta;
        private static final Field verifiedSigners;
        private static final Field sigFileSigners;
        private static final Field anyToVerify;

        private Reflection() {
        }

        @Override
        public Object getJarVerifier(Object inst) {
            return Reflection.getField(jarVerifier, inst);
        }

        @Override
        public boolean isParsingMeta(Object inst) {
            return (Boolean)Reflection.getField(parsingMeta, inst);
        }

        @Override
        public boolean hasSignatures(Object inst) {
            return (Boolean)Reflection.getField(anyToVerify, inst);
        }

        @Override
        public Map<String, CodeSigner[]> getVerifiedSigners(Object inst) {
            return (Map)Reflection.getField(verifiedSigners, inst);
        }

        @Override
        public Map<String, CodeSigner[]> getPendingSigners(Object inst) {
            return (Map)Reflection.getField(verifiedSigners, inst);
        }

        private static Object getField(Field f, Object inst) {
            try {
                return f.get(inst);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            ModuleLayer moduleLayer = ModuleLayer.boot();
            Optional<Module> myModule = moduleLayer.findModule("cpw.mods.securejarhandler");
            if (myModule.isPresent()) {
                Module gj9h = myModule.get();
                moduleLayer.findModule("java.base").filter(m -> m.isOpen("java.util.jar", gj9h) && m.isExported("sun.security.util", gj9h)).orElseThrow(() -> new IllegalStateException("Missing JVM arguments. Please correct your runtime profile and run again.\n    --add-opens java.base/java.util.jar=cpw.mods.securejarhandler\n    --add-exports java.base/sun.security.util=cpw.mods.securejarhandler"));
            } else if (Boolean.parseBoolean(System.getProperty("securejarhandler.throwOnMissingModule", "true"))) {
                throw new RuntimeException("Failed to find securejarhandler module!");
            }
            try {
                jarVerifier = JarInputStream.class.getDeclaredField("jv");
                sigFileSigners = jarVerifier.getType().getDeclaredField("sigFileSigners");
                verifiedSigners = jarVerifier.getType().getDeclaredField("verifiedSigners");
                parsingMeta = jarVerifier.getType().getDeclaredField("parsingMeta");
                anyToVerify = jarVerifier.getType().getDeclaredField("anyToVerify");
                jarVerifier.setAccessible(true);
                sigFileSigners.setAccessible(true);
                verifiedSigners.setAccessible(true);
                parsingMeta.setAccessible(true);
                anyToVerify.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Missing essential fields", e);
            }
        }
    }
}

