/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource.transformer;

import java.util.Map;
import net.md_5.specialsource.JarRemapper;

public class MethodDescriptor {
    private Map<String, String> packageMap;
    private Map<String, String> classMap;

    public MethodDescriptor(Map<String, String> packageMap, Map<String, String> classMap) {
        this.packageMap = packageMap;
        this.classMap = classMap;
    }

    public String transform(String input) {
        StringBuilder output = new StringBuilder();
        block8: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case 'L': {
                    String rest = input.substring(i);
                    int end = rest.indexOf(59);
                    if (end == -1) {
                        throw new IllegalArgumentException("Invalid method descriptor, found L but missing ;: " + input);
                    }
                    String className = rest.substring(1, end);
                    i += className.length() + 1;
                    String newClassName = JarRemapper.mapTypeName(className, this.packageMap, this.classMap, className);
                    output.append("L").append(newClassName).append(";");
                    continue block8;
                }
                case '(': 
                case ')': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    output.append(c);
                    continue block8;
                }
                case 'T': {
                    throw new IllegalArgumentException("Method descriptors with type variables unsupported: " + c);
                }
                case '<': {
                    throw new IllegalArgumentException("Method descriptors with optional arguments unsupported: " + c);
                }
                case '*': 
                case '+': 
                case '-': {
                    throw new IllegalArgumentException("Method descriptors with wildcards unsupported: " + c);
                }
                case '!': 
                case 'Q': 
                case '|': {
                    throw new IllegalArgumentException("Method descriptors with advanced types unsupported: " + c);
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized type in method descriptor: " + c);
                }
            }
        }
        return output.toString();
    }
}

