/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

public interface CollectionCountsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<Entry<T, P>> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionCountsPredicate<T, P>> codec(Codec<P> p_341206_) {
        return Entry.codec(p_341206_).listOf().xmap(CollectionCountsPredicate::of, CollectionCountsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionCountsPredicate<T, P> of(Entry<T, P> ... p_341225_) {
        return CollectionCountsPredicate.of(List.of(p_341225_));
    }

    public static <T, P extends Predicate<T>> CollectionCountsPredicate<T, P> of(List<Entry<T, P>> p_341102_) {
        return switch (p_341102_.size()) {
            case 0 -> new Zero();
            case 1 -> new Single<T, P>(p_341102_.getFirst());
            default -> new Multiple<T, P>(p_341102_);
        };
    }

    public record Entry<T, P extends Predicate<T>>(P test, MinMaxBounds.Ints count) {
        public static <T, P extends Predicate<T>> Codec<Entry<T, P>> codec(Codec<P> p_341286_) {
            return RecordCodecBuilder.create(p_340986_ -> p_340986_.group((App)p_341286_.fieldOf("test").forGetter(Entry::test), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").forGetter(Entry::count)).apply((Applicative)p_340986_, Entry::new));
        }

        public boolean test(Iterable<T> p_340995_) {
            int $$1 = 0;
            for (T $$2 : p_340995_) {
                if (!this.test.test($$2)) continue;
                ++$$1;
            }
            return this.count.matches($$1);
        }
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionCountsPredicate<T, P> {
        @Override
        public boolean test(Iterable<T> p_341222_) {
            return true;
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return List.of();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Single<T, P extends Predicate<T>>(Entry<T, P> entry) implements CollectionCountsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> p_341391_) {
            return this.entry.test(p_341391_);
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return List.of(this.entry);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<Entry<T, P>> entries) implements CollectionCountsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> p_340928_) {
            for (Entry<T, P> $$1 : this.entries) {
                if ($$1.test(p_340928_)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return this.entries;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }
}

