/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class IntegerArgumentInfo
implements ArgumentTypeInfo<IntegerArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template p_235551_, FriendlyByteBuf p_235552_) {
        boolean $$2 = p_235551_.min != Integer.MIN_VALUE;
        boolean $$3 = p_235551_.max != Integer.MAX_VALUE;
        p_235552_.writeByte(ArgumentUtils.createNumberFlags($$2, $$3));
        if ($$2) {
            p_235552_.writeInt(p_235551_.min);
        }
        if ($$3) {
            p_235552_.writeInt(p_235551_.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf p_235554_) {
        byte $$1 = p_235554_.readByte();
        int $$2 = ArgumentUtils.numberHasMin($$1) ? p_235554_.readInt() : Integer.MIN_VALUE;
        int $$3 = ArgumentUtils.numberHasMax($$1) ? p_235554_.readInt() : Integer.MAX_VALUE;
        return new Template($$2, $$3);
    }

    @Override
    public void serializeToJson(Template p_235548_, JsonObject p_235549_) {
        if (p_235548_.min != Integer.MIN_VALUE) {
            p_235549_.addProperty("min", (Number)p_235548_.min);
        }
        if (p_235548_.max != Integer.MAX_VALUE) {
            p_235549_.addProperty("max", (Number)p_235548_.max);
        }
    }

    @Override
    public Template unpack(IntegerArgumentType p_235540_) {
        return new Template(p_235540_.getMinimum(), p_235540_.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.deserializeFromNetwork(friendlyByteBuf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<IntegerArgumentType> {
        final int min;
        final int max;

        Template(int p_235562_, int p_235563_) {
            this.min = p_235562_;
            this.max = p_235563_;
        }

        @Override
        public IntegerArgumentType instantiate(CommandBuildContext p_235566_) {
            return IntegerArgumentType.integer((int)this.min, (int)this.max);
        }

        @Override
        public ArgumentTypeInfo<IntegerArgumentType, ?> type() {
            return IntegerArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

