/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>(p_255625_){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255765_) {
                return p_255625_.get(p_255765_);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> p_312781_, final Lifecycle p_312783_, HolderOwner<T> p_326787_, final Map<ResourceKey<T>, Holder.Reference<T>> p_312180_) {
        return new EmptyTagRegistryLookup<T>(p_326787_){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return p_312781_;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return p_312783_;
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_312659_) {
                return Optional.ofNullable((Holder.Reference)p_312180_.get(p_312659_));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return p_312180_.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.entries.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.add(p_256261_, Lifecycle.stable(), p_256010_);
    }

    private BuildState createState(RegistryAccess p_256400_) {
        BuildState $$1 = BuildState.create(p_256400_, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(p_255629_ -> p_255629_.apply($$1));
        return $$1;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner p_326837_, RegistryAccess p_312694_, Stream<HolderLookup.RegistryLookup<?>> p_312024_) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> p_326874_) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(p_326874_, p_326874_), RegistryOps.RegistryInfo.fromRegistryLookup(p_326874_));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner p_326836_, HolderLookup.RegistryLookup<T> p_326940_) {
                return new Entry(new EmptyTagLookupWrapper(p_326836_.cast(), p_326940_), new RegistryOps.RegistryInfo(p_326836_.cast(), p_326940_, p_326940_.registryLifecycle()));
            }
        }
        final HashMap $$3 = new HashMap();
        p_312694_.registries().forEach(p_326730_ -> $$3.put(p_326730_.key(), Entry.createForContextRegistry(p_326730_.value().asLookup())));
        p_312024_.forEach(p_326724_ -> $$3.put(p_326724_.key(), Entry.createForNewRegistry(p_326837_, p_326724_)));
        return new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return $$3.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> p_326910_) {
                return Optional.ofNullable((Entry)$$3.get(p_326910_));
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_326942_) {
                return this.getEntry(p_326942_).map(Entry::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> p_326947_) {
                return RegistryOps.create(p_326947_, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_326905_) {
                        return this.getEntry(p_326905_).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess p_256112_) {
        BuildState $$1 = this.createState(p_256112_);
        Stream<HolderLookup.RegistryLookup<?>> $$2 = this.entries.stream().map(p_326726_ -> p_326726_.collectRegisteredValues($$1).buildAsLookup(p_326725_.owner));
        HolderLookup.Provider $$3 = RegistrySetBuilder.buildProviderWithContext($$1.owner, p_256112_, $$2);
        $$1.reportNotCollectedHolders();
        $$1.reportUnclaimedRegisteredValues();
        $$1.throwOnError();
        return $$3;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess p_312301_, HolderLookup.Provider p_311942_, Cloner.Factory p_312464_, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> p_312890_, HolderLookup.Provider p_311825_) {
        UniversalOwner $$5 = new UniversalOwner();
        MutableObject $$6 = new MutableObject();
        List $$7 = p_312890_.keySet().stream().map(p_311471_ -> this.createLazyFullPatchedRegistries($$5, p_312464_, (ResourceKey)p_311471_, p_311825_, p_311942_, (MutableObject<HolderLookup.Provider>)$$6)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider $$8 = RegistrySetBuilder.buildProviderWithContext($$5, p_312301_, $$7.stream());
        $$6.setValue((Object)$$8);
        return $$8;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> p_312323_, Cloner.Factory p_311780_, ResourceKey<? extends Registry<? extends T>> p_311836_, HolderLookup.Provider p_312115_, HolderLookup.Provider p_312725_, MutableObject<HolderLookup.Provider> p_311797_) {
        Cloner $$6 = p_311780_.cloner(p_311836_);
        if ($$6 == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(p_311836_.location()));
        }
        HashMap $$7 = new HashMap();
        HolderLookup.RegistryLookup $$8 = p_312115_.lookupOrThrow(p_311836_);
        $$8.listElements().forEach(p_311483_ -> {
            ResourceKey $$6 = p_311483_.key();
            LazyHolder $$7 = new LazyHolder(p_312323_, $$6);
            $$7.supplier = () -> $$6.clone(p_311483_.value(), p_312115_, (HolderLookup.Provider)p_311797_.getValue());
            $$7.put($$6, $$7);
        });
        HolderLookup.RegistryLookup $$9 = p_312725_.lookupOrThrow(p_311836_);
        $$9.listElements().forEach(p_311506_ -> {
            ResourceKey $$6 = p_311506_.key();
            $$7.computeIfAbsent($$6, p_311494_ -> {
                LazyHolder $$7 = new LazyHolder(p_312323_, $$6);
                $$7.supplier = () -> $$6.clone(p_311506_.value(), p_312725_, (HolderLookup.Provider)p_311797_.getValue());
                return $$7;
            });
        });
        Lifecycle $$10 = $$8.registryLifecycle().add($$9.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(p_311836_, $$10, p_312323_, $$7);
    }

    public PatchedRegistries buildPatch(RegistryAccess p_255676_, HolderLookup.Provider p_255900_, Cloner.Factory p_312173_) {
        BuildState $$3 = this.createState(p_255676_);
        HashMap $$4 = new HashMap();
        this.entries.stream().map(p_311508_ -> p_311508_.collectRegisteredValues($$3)).forEach(p_272339_ -> $$4.put((ResourceKey<Registry<?>>)p_272339_.key, (RegistryContents<?>)p_272339_));
        Set $$5 = p_255676_.listRegistries().collect(Collectors.toUnmodifiableSet());
        p_255900_.listRegistries().filter(p_311485_ -> !$$5.contains(p_311485_)).forEach(p_311473_ -> $$4.putIfAbsent((ResourceKey<Registry<?>>)p_311473_, new RegistryContents(p_311473_, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> $$6 = $$4.values().stream().map(p_326728_ -> p_326728_.buildAsLookup(p_326727_.owner));
        HolderLookup.Provider $$7 = RegistrySetBuilder.buildProviderWithContext($$3.owner, p_255676_, $$6);
        $$3.reportUnclaimedRegisteredValues();
        $$3.throwOnError();
        HolderLookup.Provider $$8 = this.createLazyFullPatchedRegistries(p_255676_, p_255900_, p_312173_, $$4, $$7);
        return new PatchedRegistries($$8, $$7);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState p_256272_) {
            this.bootstrap.run(p_256272_.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState p_256416_) {
            HashMap $$1 = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> $$2 = p_256416_.registeredValues.entrySet().iterator();
            while ($$2.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> $$3 = $$2.next();
                ResourceKey<?> $$4 = $$3.getKey();
                if (!$$4.isFor(this.key)) continue;
                ResourceKey<?> $$5 = $$4;
                RegisteredValue<?> $$6 = $$3.getValue();
                Holder.Reference<Object> $$7 = p_256416_.lookup.holders.remove($$4);
                $$1.put($$5, new ValueAndHolder($$6, Optional.ofNullable($$7)));
                $$2.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, $$1);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    record BuildState(UniversalOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            UniversalOwner $$2 = new UniversalOwner();
            ArrayList<RuntimeException> $$3 = new ArrayList<RuntimeException>();
            UniversalLookup $$4 = new UniversalLookup($$2);
            ImmutableMap.Builder $$5 = ImmutableMap.builder();
            p_255995_.registries().forEach(p_258197_ -> $$5.put((Object)p_258197_.key().location(), RegistrySetBuilder.wrapContextLookup(p_258197_.value().asLookup())));
            p_256495_.forEach(p_256603_ -> $$5.put((Object)p_256603_.location(), (Object)$$4));
            return new BuildState($$2, $$4, (Map<ResourceLocation, HolderGetter<?>>)$$5.build(), new HashMap(), (List<RuntimeException>)$$3);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue $$3 = registeredValues.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if ($$3 != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(p_256176_) + ", new=" + String.valueOf(p_256422_) + ", old=" + String.valueOf($$3.value)));
                    }
                    return lookup.getOrCreate(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return registries.getOrDefault(p_255961_.location(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((p_339338_, p_339339_) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(p_339339_.value) + " for key " + String.valueOf(p_339338_))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> $$0 : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf($$0)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException $$0 = new IllegalStateException("Errors during registry creation");
                for (RuntimeException $$1 : this.errors) {
                    $$0.addSuppressed($$1);
                }
                throw $$0;
            }
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner p_326796_) {
            Map $$1 = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_311927_ -> {
                ValueAndHolder $$2 = (ValueAndHolder)p_311927_.getValue();
                Holder.Reference $$3 = $$2.holder().orElseGet(() -> Holder.Reference.createStandAlone(p_326796_.cast(), (ResourceKey)p_311927_.getKey()));
                $$3.bindValue($$2.value().value());
                return $$3;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, p_326796_.cast(), $$1);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> p_312861_, @Nullable ResourceKey<T> p_312263_) {
            super(Holder.Reference.Type.STAND_ALONE, p_312861_, p_312263_, null);
        }

        @Override
        protected void bindValue(T p_312469_) {
            super.bindValue(p_312469_);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> p_256303_) {
            return Optional.of(this.getOrCreate(p_256303_));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> p_256298_) {
            return this.holders.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.createStandAlone(this.owner, p_256154_));
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> p_326948_, HolderLookup.RegistryLookup<T> p_326784_) {
            super(p_326948_);
            this.parent = p_326784_;
        }

        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> p_326933_) {
            super(p_326933_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.owner = p_256166_;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.emptyNamed(this.owner, p_256664_));
        }
    }
}

