/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceKey<LootTable>> p_254481_, List<SubProviderEntry> p_253798_, CompletableFuture<HolderLookup.Provider> p_323798_) {
        this.pathProvider = p_254123_.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
        this.registries = p_323798_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        return this.registries.thenCompose(p_323117_ -> this.run(p_254060_, (HolderLookup.Provider)p_323117_));
    }

    private CompletableFuture<?> run(CachedOutput p_324447_, HolderLookup.Provider p_323978_) {
        MappedRegistry<LootTable> $$2 = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap $$3 = new Object2ObjectOpenHashMap();
        this.subProviders.forEach(arg_0 -> LootTableProvider.lambda$run$2(p_323978_, (Map)$$3, $$2, arg_0));
        $$2.freeze();
        ProblemReporter.Collector $$4 = new ProblemReporter.Collector();
        HolderGetter.Provider $$5 = new RegistryAccess.ImmutableRegistryAccess(List.of($$2)).freeze().asGetterLookup();
        ValidationContext $$6 = new ValidationContext($$4, LootContextParamSets.ALL_PARAMS, $$5);
        Sets.SetView $$7 = Sets.difference(this.requiredTables, $$2.registryKeySet());
        for (ResourceKey $$8 : $$7) {
            $$4.report("Missing built-in table: " + String.valueOf($$8.location()));
        }
        $$2.holders().forEach(p_339369_ -> ((LootTable)p_339369_.value()).validate($$6.setParams(((LootTable)p_339369_.value()).getParamSet()).enterElement("{" + String.valueOf(p_339369_.key().location()) + "}", p_339369_.key())));
        Multimap<String, String> $$9 = $$4.get();
        if (!$$9.isEmpty()) {
            $$9.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])$$2.entrySet().stream().map(p_335193_ -> {
            ResourceKey $$3 = (ResourceKey)p_335193_.getKey();
            LootTable $$4 = (LootTable)p_335193_.getValue();
            Path $$5 = this.pathProvider.json($$3.location());
            return DataProvider.saveStable(p_324447_, p_323978_, LootTable.DIRECT_CODEC, $$4, $$5);
        }).toArray(CompletableFuture[]::new));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_336172_) {
        return p_336172_.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider p_344194_, Map p_344195_, WritableRegistry p_344196_, SubProviderEntry p_344197_) {
        p_344197_.provider().apply(p_344194_).generate((p_339366_, p_339367_) -> {
            ResourceLocation $$5 = LootTableProvider.sequenceIdForLootTable(p_339366_);
            ResourceLocation $$6 = p_344195_.put(RandomSequence.seedForKey($$5), $$5);
            if ($$6 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf($$6) + " and " + String.valueOf(p_339366_.location()));
            }
            p_339367_.setRandomSequence($$5);
            LootTable $$7 = p_339367_.setParamSet(p_339364_.paramSet).build();
            p_344196_.register(p_339366_, $$7, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, LootTableSubProvider> provider, LootContextParamSet paramSet) {
    }
}

