/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float DEEP_OCEAN_CONTINENTALNESS = -0.51f;
    private static final float OCEAN_CONTINENTALNESS = -0.4f;
    private static final float PLAINS_CONTINENTALNESS = 0.1f;
    private static final float BEACH_CONTINENTALNESS = -0.15f;
    private static final ToFloatFunction<Float> NO_TRANSFORM = ToFloatFunction.IDENTITY;
    private static final ToFloatFunction<Float> AMPLIFIED_OFFSET = ToFloatFunction.createUnlimited(p_236651_ -> p_236651_ < 0.0f ? p_236651_ : p_236651_ * 2.0f);
    private static final ToFloatFunction<Float> AMPLIFIED_FACTOR = ToFloatFunction.createUnlimited(p_236649_ -> 1.25f - 6.25f / (p_236649_ + 5.0f));
    private static final ToFloatFunction<Float> AMPLIFIED_JAGGEDNESS = ToFloatFunction.createUnlimited(p_236641_ -> p_236641_ * 2.0f);

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldOffset(I p_236636_, I p_236637_, I p_236638_, boolean p_236639_) {
        ToFloatFunction<Float> $$4 = p_236639_ ? AMPLIFIED_OFFSET : NO_TRANSFORM;
        CubicSpline<C, I> $$5 = TerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, $$4);
        CubicSpline<C, I> $$6 = TerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, $$4);
        CubicSpline<C, I> $$7 = TerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, $$4);
        CubicSpline<C, I> $$8 = TerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, $$4);
        return CubicSpline.builder(p_236636_, $$4).addPoint(-1.1f, 0.044f).addPoint(-1.02f, -0.2222f).addPoint(-0.51f, -0.2222f).addPoint(-0.44f, -0.12f).addPoint(-0.18f, -0.12f).addPoint(-0.16f, $$5).addPoint(-0.15f, $$5).addPoint(-0.1f, $$6).addPoint(0.25f, $$7).addPoint(1.0f, $$8).build();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldFactor(I p_236630_, I p_236631_, I p_236632_, I p_236633_, boolean p_236634_) {
        ToFloatFunction<Float> $$5 = p_236634_ ? AMPLIFIED_FACTOR : NO_TRANSFORM;
        return CubicSpline.builder(p_236630_, NO_TRANSFORM).addPoint(-0.19f, 3.95f).addPoint(-0.15f, TerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 6.25f, true, NO_TRANSFORM)).addPoint(-0.1f, TerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 5.47f, true, $$5)).addPoint(0.03f, TerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 5.08f, true, $$5)).addPoint(0.06f, TerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 4.69f, false, $$5)).build();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldJaggedness(I p_236643_, I p_236644_, I p_236645_, I p_236646_, boolean p_236647_) {
        ToFloatFunction<Float> $$5 = p_236647_ ? AMPLIFIED_JAGGEDNESS : NO_TRANSFORM;
        float $$6 = 0.65f;
        return CubicSpline.builder(p_236643_, $$5).addPoint(-0.11f, 0.0f).addPoint(0.03f, TerrainProvider.buildErosionJaggednessSpline(p_236644_, p_236645_, p_236646_, 1.0f, 0.5f, 0.0f, 0.0f, $$5)).addPoint(0.65f, TerrainProvider.buildErosionJaggednessSpline(p_236644_, p_236645_, p_236646_, 1.0f, 1.0f, 1.0f, 0.0f, $$5)).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I p_236614_, I p_236615_, I p_236616_, float p_236617_, float p_236618_, float p_236619_, float p_236620_, ToFloatFunction<Float> p_236621_) {
        float $$8 = -0.5775f;
        CubicSpline<C, I> $$9 = TerrainProvider.buildRidgeJaggednessSpline(p_236615_, p_236616_, p_236617_, p_236619_, p_236621_);
        CubicSpline<C, I> $$10 = TerrainProvider.buildRidgeJaggednessSpline(p_236615_, p_236616_, p_236618_, p_236620_, p_236621_);
        return CubicSpline.builder(p_236614_, p_236621_).addPoint(-1.0f, $$9).addPoint(-0.78f, $$10).addPoint(-0.5775f, $$10).addPoint(-0.375f, 0.0f).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I p_236608_, I p_236609_, float p_236610_, float p_236611_, ToFloatFunction<Float> p_236612_) {
        float $$5 = NoiseRouterData.peaksAndValleys(0.4f);
        float $$6 = NoiseRouterData.peaksAndValleys(0.56666666f);
        float $$7 = ($$5 + $$6) / 2.0f;
        CubicSpline.Builder<C, I> $$8 = CubicSpline.builder(p_236609_, p_236612_);
        $$8.addPoint($$5, 0.0f);
        if (p_236611_ > 0.0f) {
            $$8.addPoint($$7, TerrainProvider.buildWeirdnessJaggednessSpline(p_236608_, p_236611_, p_236612_));
        } else {
            $$8.addPoint($$7, 0.0f);
        }
        if (p_236610_ > 0.0f) {
            $$8.addPoint(1.0f, TerrainProvider.buildWeirdnessJaggednessSpline(p_236608_, p_236610_, p_236612_));
        } else {
            $$8.addPoint(1.0f, 0.0f);
        }
        return $$8.build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I p_236587_, float p_236588_, ToFloatFunction<Float> p_236589_) {
        float $$3 = 0.63f * p_236588_;
        float $$4 = 0.3f * p_236588_;
        return CubicSpline.builder(p_236587_, p_236589_).addPoint(-0.01f, $$3).addPoint(0.01f, $$4).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I p_236623_, I p_236624_, I p_236625_, float p_236626_, boolean p_236627_, ToFloatFunction<Float> p_236628_) {
        CubicSpline $$6 = CubicSpline.builder(p_236624_, p_236628_).addPoint(-0.2f, 6.3f).addPoint(0.2f, p_236626_).build();
        CubicSpline.Builder $$7 = CubicSpline.builder(p_236623_, p_236628_).addPoint(-0.6f, $$6).addPoint(-0.5f, CubicSpline.builder(p_236624_, p_236628_).addPoint(-0.05f, 6.3f).addPoint(0.05f, 2.67f).build()).addPoint(-0.35f, $$6).addPoint(-0.25f, $$6).addPoint(-0.1f, CubicSpline.builder(p_236624_, p_236628_).addPoint(-0.05f, 2.67f).addPoint(0.05f, 6.3f).build()).addPoint(0.03f, $$6);
        if (p_236627_) {
            CubicSpline $$8 = CubicSpline.builder(p_236624_, p_236628_).addPoint(0.0f, p_236626_).addPoint(0.1f, 0.625f).build();
            CubicSpline $$9 = CubicSpline.builder(p_236625_, p_236628_).addPoint(-0.9f, p_236626_).addPoint(-0.69f, $$8).build();
            $$7.addPoint(0.35f, p_236626_).addPoint(0.45f, $$9).addPoint(0.55f, $$9).addPoint(0.62f, p_236626_);
        } else {
            CubicSpline $$10 = CubicSpline.builder(p_236625_, p_236628_).addPoint(-0.7f, $$6).addPoint(-0.15f, 1.37f).build();
            CubicSpline $$11 = CubicSpline.builder(p_236625_, p_236628_).addPoint(0.45f, $$6).addPoint(0.7f, 1.56f).build();
            $$7.addPoint(0.05f, $$11).addPoint(0.4f, $$11).addPoint(0.45f, $$10).addPoint(0.55f, $$10).addPoint(0.58f, p_236626_);
        }
        return $$7.build();
    }

    private static float calculateSlope(float p_236573_, float p_236574_, float p_236575_, float p_236576_) {
        return (p_236574_ - p_236573_) / (p_236576_ - p_236575_);
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I p_236591_, float p_236592_, boolean p_236593_, ToFloatFunction<Float> p_236594_) {
        CubicSpline.Builder $$4 = CubicSpline.builder(p_236591_, p_236594_);
        float $$5 = -0.7f;
        float $$6 = -1.0f;
        float $$7 = TerrainProvider.mountainContinentalness(-1.0f, p_236592_, -0.7f);
        float $$8 = 1.0f;
        float $$9 = TerrainProvider.mountainContinentalness(1.0f, p_236592_, -0.7f);
        float $$10 = TerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(p_236592_);
        float $$11 = -0.65f;
        if (-0.65f < $$10 && $$10 < 1.0f) {
            float $$12 = TerrainProvider.mountainContinentalness(-0.65f, p_236592_, -0.7f);
            float $$13 = -0.75f;
            float $$14 = TerrainProvider.mountainContinentalness(-0.75f, p_236592_, -0.7f);
            float $$15 = TerrainProvider.calculateSlope($$7, $$14, -1.0f, -0.75f);
            $$4.addPoint(-1.0f, $$7, $$15);
            $$4.addPoint(-0.75f, $$14);
            $$4.addPoint(-0.65f, $$12);
            float $$16 = TerrainProvider.mountainContinentalness($$10, p_236592_, -0.7f);
            float $$17 = TerrainProvider.calculateSlope($$16, $$9, $$10, 1.0f);
            float $$18 = 0.01f;
            $$4.addPoint($$10 - 0.01f, $$16);
            $$4.addPoint($$10, $$16, $$17);
            $$4.addPoint(1.0f, $$9, $$17);
        } else {
            float $$19 = TerrainProvider.calculateSlope($$7, $$9, -1.0f, 1.0f);
            if (p_236593_) {
                $$4.addPoint(-1.0f, Math.max(0.2f, $$7));
                $$4.addPoint(0.0f, Mth.lerp(0.5f, $$7, $$9), $$19);
            } else {
                $$4.addPoint(-1.0f, $$7, $$19);
            }
            $$4.addPoint(1.0f, $$9, $$19);
        }
        return $$4.build();
    }

    private static float mountainContinentalness(float p_236569_, float p_236570_, float p_236571_) {
        float $$3 = 1.17f;
        float $$4 = 0.46082947f;
        float $$5 = 1.0f - (1.0f - p_236570_) * 0.5f;
        float $$6 = 0.5f * (1.0f - p_236570_);
        float $$7 = (p_236569_ + 1.17f) * 0.46082947f;
        float $$8 = $$7 * $$5 - $$6;
        if (p_236569_ < p_236571_) {
            return Math.max($$8, -0.2222f);
        }
        return Math.max($$8, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float p_236567_) {
        float $$1 = 1.17f;
        float $$2 = 0.46082947f;
        float $$3 = 1.0f - (1.0f - p_236567_) * 0.5f;
        float $$4 = 0.5f * (1.0f - p_236567_);
        return $$4 / (0.46082947f * $$3) - 1.17f;
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I p_236596_, I p_236597_, float p_236598_, float p_236599_, float p_236600_, float p_236601_, float p_236602_, float p_236603_, boolean p_236604_, boolean p_236605_, ToFloatFunction<Float> p_236606_) {
        float $$11 = 0.6f;
        float $$12 = 0.5f;
        float $$13 = 0.5f;
        CubicSpline<C, I> $$14 = TerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, Mth.lerp(p_236601_, 0.6f, 1.5f), p_236605_, p_236606_);
        CubicSpline<C, I> $$15 = TerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, Mth.lerp(p_236601_, 0.6f, 1.0f), p_236605_, p_236606_);
        CubicSpline<C, I> $$16 = TerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, p_236601_, p_236605_, p_236606_);
        CubicSpline<C, I> $$17 = TerrainProvider.ridgeSpline(p_236597_, p_236598_ - 0.15f, 0.5f * p_236601_, Mth.lerp(0.5f, 0.5f, 0.5f) * p_236601_, 0.5f * p_236601_, 0.6f * p_236601_, 0.5f, p_236606_);
        CubicSpline<C, I> $$18 = TerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_ * p_236601_, p_236599_ * p_236601_, 0.5f * p_236601_, 0.6f * p_236601_, 0.5f, p_236606_);
        CubicSpline<C, I> $$19 = TerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_, p_236602_, p_236599_, p_236600_, 0.5f, p_236606_);
        CubicSpline<C, I> $$20 = TerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_, p_236602_, p_236599_, p_236600_, 0.5f, p_236606_);
        CubicSpline $$21 = CubicSpline.builder(p_236597_, p_236606_).addPoint(-1.0f, p_236598_).addPoint(-0.4f, $$19).addPoint(0.0f, p_236600_ + 0.07f).build();
        CubicSpline<C, I> $$22 = TerrainProvider.ridgeSpline(p_236597_, -0.02f, p_236603_, p_236603_, p_236599_, p_236600_, 0.0f, p_236606_);
        CubicSpline.Builder<C, I> $$23 = CubicSpline.builder(p_236596_, p_236606_).addPoint(-0.85f, $$14).addPoint(-0.7f, $$15).addPoint(-0.4f, $$16).addPoint(-0.35f, $$17).addPoint(-0.1f, $$18).addPoint(0.2f, $$19);
        if (p_236604_) {
            $$23.addPoint(0.4f, $$20).addPoint(0.45f, $$21).addPoint(0.55f, $$21).addPoint(0.58f, $$20);
        }
        $$23.addPoint(0.7f, $$22);
        return $$23.build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I p_236578_, float p_236579_, float p_236580_, float p_236581_, float p_236582_, float p_236583_, float p_236584_, ToFloatFunction<Float> p_236585_) {
        float $$8 = Math.max(0.5f * (p_236580_ - p_236579_), p_236584_);
        float $$9 = 5.0f * (p_236581_ - p_236580_);
        return CubicSpline.builder(p_236578_, p_236585_).addPoint(-1.0f, p_236579_, $$8).addPoint(-0.4f, p_236580_, Math.min($$8, $$9)).addPoint(0.0f, p_236581_, $$9).addPoint(0.4f, p_236582_, 2.0f * (p_236582_ - p_236581_)).addPoint(1.0f, p_236583_, 0.7f * (p_236583_ - p_236582_)).build();
    }
}

