/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    final ConnectionProtocol protocol;
    final PacketFlow flow;
    private final List<CodecEntry<T, ?, B>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(ConnectionProtocol p_320213_, PacketFlow p_320424_) {
        this.protocol = p_320213_;
        this.flow = p_320424_;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> addPacket(PacketType<P> p_320673_, StreamCodec<? super B, P> p_319828_) {
        this.codecs.add(new CodecEntry(p_320673_, p_319828_));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> withBundlePacket(PacketType<P> p_320954_, Function<Iterable<Packet<? super T>>, P> p_320241_, D p_320202_) {
        StreamCodec $$3 = StreamCodec.unit(p_320202_);
        PacketType<BundleDelimiterPacket<? super T>> $$4 = p_320202_.type();
        this.codecs.add(new CodecEntry($$4, $$3));
        this.bundlerInfo = BundlerInfo.createForPacket(p_320954_, p_320241_, p_320202_);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> p_320922_, List<CodecEntry<T, ?, B>> p_320733_) {
        ProtocolCodecBuilder $$2 = new ProtocolCodecBuilder(this.flow);
        for (CodecEntry codecEntry : p_320733_) {
            codecEntry.addToBuilder($$2, p_320922_);
        }
        return $$2.build();
    }

    public ProtocolInfo<T> build(Function<ByteBuf, B> p_319806_) {
        return new Implementation(this.protocol, this.flow, this.buildPacketCodec(p_319806_, this.codecs), this.bundlerInfo);
    }

    public ProtocolInfo.Unbound<T, B> buildUnbound() {
        final List<CodecEntry<T, ?, B>> $$0 = List.copyOf(this.codecs);
        final BundlerInfo $$1 = this.bundlerInfo;
        return new ProtocolInfo.Unbound<T, B>(){

            @Override
            public ProtocolInfo<T> bind(Function<ByteBuf, B> p_352173_) {
                return new Implementation(ProtocolInfoBuilder.this.protocol, ProtocolInfoBuilder.this.flow, ProtocolInfoBuilder.this.buildPacketCodec(p_352173_, $$0), $$1);
            }

            @Override
            public ConnectionProtocol id() {
                return ProtocolInfoBuilder.this.protocol;
            }

            @Override
            public PacketFlow flow() {
                return ProtocolInfoBuilder.this.flow;
            }

            @Override
            public void listPackets(ProtocolInfo.Unbound.PacketVisitor p_352332_) {
                for (int $$12 = 0; $$12 < $$0.size(); ++$$12) {
                    CodecEntry $$2 = (CodecEntry)$$0.get($$12);
                    p_352332_.accept($$2.type, $$12);
                }
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.Unbound<L, B> protocol(ConnectionProtocol p_320849_, PacketFlow p_320146_, Consumer<ProtocolInfoBuilder<L, B>> p_320140_) {
        ProtocolInfoBuilder $$3 = new ProtocolInfoBuilder(p_320849_, p_320146_);
        p_320140_.accept($$3);
        return $$3.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> serverboundProtocol(ConnectionProtocol p_319767_, Consumer<ProtocolInfoBuilder<T, B>> p_320799_) {
        return ProtocolInfoBuilder.protocol(p_319767_, PacketFlow.SERVERBOUND, p_320799_);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.Unbound<T, B> clientboundProtocol(ConnectionProtocol p_320428_, Consumer<ProtocolInfoBuilder<T, B>> p_320292_) {
        return ProtocolInfoBuilder.protocol(p_320428_, PacketFlow.CLIENTBOUND, p_320292_);
    }

    record CodecEntry<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> p_320857_, Function<ByteBuf, B> p_320646_) {
            StreamCodec<ByteBuf, P> $$2 = this.serializer.mapStream(p_320646_);
            p_320857_.add(this.type, $$2);
        }
    }

    record Implementation<L extends PacketListener>(ConnectionProtocol id, PacketFlow flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

