/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFixedCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;

    public static <E> RegistryFixedCodec<E> create(ResourceKey<? extends Registry<E>> p_206741_) {
        return new RegistryFixedCodec<E>(p_206741_);
    }

    private RegistryFixedCodec(ResourceKey<? extends Registry<E>> p_206723_) {
        this.registryKey = p_206723_;
    }

    public <T> DataResult<T> encode(Holder<E> p_206729_, DynamicOps<T> p_206730_, T p_206731_) {
        RegistryOps $$3;
        Optional $$4;
        if (p_206730_ instanceof RegistryOps && ($$4 = ($$3 = (RegistryOps)p_206730_).owner(this.registryKey)).isPresent()) {
            if (!p_206729_.canSerializeIn($$4.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(p_206729_) + " is not valid in current registry set");
            }
            return (DataResult)p_206729_.unwrap().map(p_206727_ -> ResourceLocation.CODEC.encode((Object)p_206727_.location(), p_206730_, p_206731_), p_274804_ -> DataResult.error(() -> "Elements from registry " + String.valueOf(this.registryKey) + " can't be serialized to a value"));
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> p_206743_, T p_206744_) {
        RegistryOps $$2;
        Optional $$3;
        if (p_206743_ instanceof RegistryOps && ($$3 = ($$2 = (RegistryOps)p_206743_).getter(this.registryKey)).isPresent()) {
            return ResourceLocation.CODEC.decode(p_206743_, p_206744_).flatMap(p_337524_ -> {
                ResourceLocation $$2 = (ResourceLocation)p_337524_.getFirst();
                return ((HolderGetter)$$3.get()).get(ResourceKey.create(this.registryKey, $$2)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf($$2))).map(p_256041_ -> Pair.of((Object)p_256041_, (Object)p_337524_.getSecond())).setLifecycle(Lifecycle.stable());
            });
        }
        return DataResult.error(() -> "Can't access registry " + String.valueOf(this.registryKey));
    }

    public String toString() {
        return "RegistryFixedCodec[" + String.valueOf(this.registryKey) + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((Holder)object, dynamicOps, object2);
    }
}

