/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    private static final ChunkResult<List<ChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<ChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap = this.updatingChunkMap.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> pendingUnloads = new Long2ObjectLinkedOpenHashMap();
    private final List<ChunkGenerationTask> pendingGenerationTasks = new ArrayList<ChunkGenerationTask>();
    final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    private final BlockableEventLoop<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<DimensionDataStorage> overworldDataStorage;
    private final PoiManager poiManager;
    final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    private final ChunkTaskPriorityQueueSorter queueSorter;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> worldgenMailbox;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> mainThreadMailbox;
    private final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    private final DistanceManager distanceManager;
    private final AtomicInteger tickingGenerated = new AtomicInteger();
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    private final Int2ObjectMap<TrackedEntity> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    private final Long2LongMap chunkSaveCooldowns = new Long2LongOpenHashMap();
    private final Queue<Runnable> unloadQueue = Queues.newConcurrentLinkedQueue();
    private int serverViewDistance;
    private final WorldGenContext worldGenContext;

    public ChunkMap(ServerLevel p_214836_, LevelStorageSource.LevelStorageAccess p_214837_, DataFixer p_214838_, StructureTemplateManager p_214839_, Executor p_214840_, BlockableEventLoop<Runnable> p_214841_, LightChunkGetter p_214842_, ChunkGenerator p_214843_, ChunkProgressListener p_214844_, ChunkStatusUpdateListener p_214845_, Supplier<DimensionDataStorage> p_214846_, int p_214847_, boolean p_214848_) {
        super(new RegionStorageInfo(p_214837_.getLevelId(), p_214836_.dimension(), "chunk"), p_214837_.getDimensionPath(p_214836_.dimension()).resolve("region"), p_214838_, p_214848_);
        Path $$13 = p_214837_.getDimensionPath(p_214836_.dimension());
        this.storageName = $$13.getFileName().toString();
        this.level = p_214836_;
        RegistryAccess $$14 = p_214836_.registryAccess();
        long $$15 = p_214836_.getSeed();
        if (p_214843_ instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator $$16 = (NoiseBasedChunkGenerator)p_214843_;
            this.randomState = RandomState.create($$16.generatorSettings().value(), $$14.lookupOrThrow(Registries.NOISE), $$15);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), $$14.lookupOrThrow(Registries.NOISE), $$15);
        }
        this.chunkGeneratorState = p_214843_.createState($$14.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, $$15);
        this.mainThreadExecutor = p_214841_;
        ProcessorMailbox<Runnable> $$17 = ProcessorMailbox.create(p_214840_, "worldgen");
        ProcessorHandle<Runnable> $$18 = ProcessorHandle.of("main", p_214841_::tell);
        this.progressListener = p_214844_;
        this.chunkStatusListener = p_214845_;
        ProcessorMailbox<Runnable> $$19 = ProcessorMailbox.create(p_214840_, "light");
        this.queueSorter = new ChunkTaskPriorityQueueSorter((List<ProcessorHandle<?>>)ImmutableList.of($$17, $$18, $$19), p_214840_, Integer.MAX_VALUE);
        this.worldgenMailbox = this.queueSorter.getProcessor($$17, false);
        this.mainThreadMailbox = this.queueSorter.getProcessor($$18, false);
        this.lightEngine = new ThreadedLevelLightEngine(p_214842_, this, this.level.dimensionType().hasSkyLight(), $$19, this.queueSorter.getProcessor($$19, false));
        this.distanceManager = new DistanceManager(p_214840_, p_214841_);
        this.overworldDataStorage = p_214846_;
        this.poiManager = new PoiManager(new RegionStorageInfo(p_214837_.getLevelId(), p_214836_.dimension(), "poi"), $$13.resolve("poi"), p_214838_, p_214848_, $$14, p_214836_.getServer(), p_214836_);
        this.setServerViewDistance(p_214847_);
        this.worldGenContext = new WorldGenContext(p_214836_, p_214843_, p_214839_, this.lightEngine, this.mainThreadMailbox);
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    private static double euclideanDistanceSquared(ChunkPos p_140227_, Entity p_140228_) {
        double $$2 = SectionPos.sectionToBlockCoord(p_140227_.x, 8);
        double $$3 = SectionPos.sectionToBlockCoord(p_140227_.z, 8);
        double $$4 = $$2 - p_140228_.getX();
        double $$5 = $$3 - p_140228_.getZ();
        return $$4 * $$4 + $$5 * $$5;
    }

    boolean isChunkTracked(ServerPlayer p_295366_, int p_294911_, int p_296247_) {
        return p_295366_.getChunkTrackingView().contains(p_294911_, p_296247_) && !p_295366_.connection.chunkSender.isPending(ChunkPos.asLong(p_294911_, p_296247_));
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer p_295596_, int p_294838_, int p_295212_) {
        if (!this.isChunkTracked(p_295596_, p_294838_, p_295212_)) {
            return false;
        }
        for (int $$3 = -1; $$3 <= 1; ++$$3) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                if ($$3 == 0 && $$4 == 0 || this.isChunkTracked(p_295596_, p_294838_ + $$3, p_295212_ + $$4)) continue;
                return true;
            }
        }
        return false;
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected ChunkHolder getUpdatingChunkIfPresent(long p_140175_) {
        return (ChunkHolder)this.updatingChunkMap.get(p_140175_);
    }

    @Nullable
    protected ChunkHolder getVisibleChunkIfPresent(long p_140328_) {
        return (ChunkHolder)this.visibleChunkMap.get(p_140328_);
    }

    protected IntSupplier getChunkQueueLevel(long p_140372_) {
        return () -> {
            ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_140372_);
            if ($$1 == null) {
                return ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1;
            }
            return Math.min($$1.getQueueLevel(), ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkPos p_140205_) {
        ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_140205_.toLong());
        if ($$1 == null) {
            return "null";
        }
        String $$2 = $$1.getTicketLevel() + "\n";
        ChunkStatus $$3 = $$1.getLatestStatus();
        ChunkAccess $$4 = $$1.getLatestChunk();
        if ($$3 != null) {
            $$2 = $$2 + "St: \u00a7" + $$3.getIndex() + String.valueOf($$3) + "\u00a7r\n";
        }
        if ($$4 != null) {
            $$2 = $$2 + "Ch: \u00a7" + $$4.getPersistedStatus().getIndex() + String.valueOf($$4.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus $$5 = $$1.getFullStatus();
        $$2 = $$2 + String.valueOf('\u00a7') + $$5.ordinal() + String.valueOf((Object)$$5);
        return $$2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder p_281446_, int p_282030_, IntFunction<ChunkStatus> p_282923_) {
        if (p_282030_ == 0) {
            ChunkStatus $$3 = p_282923_.apply(0);
            return p_281446_.scheduleChunkGenerationTask($$3, this).thenApply(p_329931_ -> p_329931_.map(List::of));
        }
        ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>> $$4 = new ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>>();
        ChunkPos $$5 = p_281446_.getPos();
        for (int $$6 = -p_282030_; $$6 <= p_282030_; ++$$6) {
            for (int $$7 = -p_282030_; $$7 <= p_282030_; ++$$7) {
                int $$8 = Math.max(Math.abs($$7), Math.abs($$6));
                long $$9 = ChunkPos.asLong($$5.x + $$7, $$5.z + $$6);
                ChunkHolder $$10 = this.getUpdatingChunkIfPresent($$9);
                if ($$10 == null) {
                    return UNLOADED_CHUNK_LIST_FUTURE;
                }
                ChunkStatus $$11 = p_282923_.apply($$8);
                $$4.add($$10.scheduleChunkGenerationTask($$11, this));
            }
        }
        return Util.sequence($$4).thenApply(p_347038_ -> {
            ArrayList $$1 = Lists.newArrayList();
            for (ChunkResult $$2 : p_347038_) {
                if ($$2 == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                ChunkAccess $$3 = $$2.orElse(null);
                if ($$3 == null) {
                    return UNLOADED_CHUNK_LIST_RESULT;
                }
                $$1.add($$3);
            }
            return ChunkResult.of($$1);
        });
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException p_203752_, String p_203753_) {
        StringBuilder $$2 = new StringBuilder();
        Consumer<ChunkHolder> $$3 = p_347055_ -> p_347055_.getAllFutures().forEach(p_347043_ -> {
            ChunkStatus $$3 = (ChunkStatus)p_347043_.getFirst();
            CompletableFuture $$4 = (CompletableFuture)p_347043_.getSecond();
            if ($$4 != null && $$4.isDone() && $$4.join() == null) {
                $$2.append(p_347055_.getPos()).append(" - status: ").append($$3).append(" future: ").append($$4).append(System.lineSeparator());
            }
        });
        $$2.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach($$3);
        $$2.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach($$3);
        CrashReport $$4 = CrashReport.forThrowable(p_203752_, "Chunk loading");
        CrashReportCategory $$5 = $$4.addCategory("Chunk loading");
        $$5.setDetail("Details", p_203753_);
        $$5.setDetail("Futures", $$2);
        return new ReportedException($$4);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder p_281455_) {
        return this.getChunkRangeFuture(p_281455_, 2, p_329942_ -> ChunkStatus.FULL).thenApplyAsync(p_329945_ -> p_329945_.map(p_214939_ -> (LevelChunk)p_214939_.get(p_214939_.size() / 2)), (Executor)this.mainThreadExecutor);
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long p_140177_, int p_140178_, @Nullable ChunkHolder p_140179_, int p_140180_) {
        if (!ChunkLevel.isLoaded(p_140180_) && !ChunkLevel.isLoaded(p_140178_)) {
            return p_140179_;
        }
        if (p_140179_ != null) {
            p_140179_.setTicketLevel(p_140178_);
        }
        if (p_140179_ != null) {
            if (!ChunkLevel.isLoaded(p_140178_)) {
                this.toDrop.add(p_140177_);
            } else {
                this.toDrop.remove(p_140177_);
            }
        }
        if (ChunkLevel.isLoaded(p_140178_) && p_140179_ == null) {
            p_140179_ = (ChunkHolder)this.pendingUnloads.remove(p_140177_);
            if (p_140179_ != null) {
                p_140179_.setTicketLevel(p_140178_);
            } else {
                p_140179_ = new ChunkHolder(new ChunkPos(p_140177_), p_140178_, this.level, this.lightEngine, this.queueSorter, this);
            }
            this.updatingChunkMap.put(p_140177_, (Object)p_140179_);
            this.modified = true;
        }
        return p_140179_;
    }

    @Override
    public void close() throws IOException {
        try {
            this.queueSorter.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean p_140319_) {
        if (p_140319_) {
            List<ChunkHolder> $$1 = this.visibleChunkMap.values().stream().filter(ChunkHolder::wasAccessibleSinceLastSave).peek(ChunkHolder::refreshAccessibility).toList();
            MutableBoolean $$2 = new MutableBoolean();
            do {
                $$2.setFalse();
                $$1.stream().map(p_347059_ -> {
                    this.mainThreadExecutor.managedBlock(p_347059_::isReadyForSaving);
                    return p_347059_.getLatestChunk();
                }).filter(p_203088_ -> p_203088_ instanceof ImposterProtoChunk || p_203088_ instanceof LevelChunk).filter(this::save).forEach(p_203051_ -> $$2.setTrue());
            } while ($$2.isTrue());
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.visibleChunkMap.values().forEach(this::saveChunkIfNeeded);
        }
    }

    protected void tick(BooleanSupplier p_140281_) {
        ProfilerFiller $$1 = this.level.getProfiler();
        $$1.push("poi");
        this.poiManager.tick(p_140281_);
        $$1.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(p_140281_);
        }
        $$1.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.queueSorter.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier p_140354_) {
        Runnable $$6;
        LongIterator $$1 = this.toDrop.iterator();
        int $$2 = 0;
        while ($$1.hasNext() && (p_140354_.getAsBoolean() || $$2 < 200 || this.toDrop.size() > 2000)) {
            long $$3 = $$1.nextLong();
            ChunkHolder $$4 = (ChunkHolder)this.updatingChunkMap.get($$3);
            if ($$4 != null) {
                if ($$4.getGenerationRefCount() != 0) continue;
                this.updatingChunkMap.remove($$3);
                this.pendingUnloads.put($$3, (Object)$$4);
                this.modified = true;
                ++$$2;
                this.scheduleUnload($$3, $$4);
            }
            $$1.remove();
        }
        for (int $$5 = Math.max(0, this.unloadQueue.size() - 2000); (p_140354_.getAsBoolean() || $$5 > 0) && ($$6 = this.unloadQueue.poll()) != null; --$$5) {
            $$6.run();
        }
        int $$7 = 0;
        ObjectIterator $$8 = this.visibleChunkMap.values().iterator();
        while ($$7 < 20 && p_140354_.getAsBoolean() && $$8.hasNext()) {
            if (!this.saveChunkIfNeeded((ChunkHolder)$$8.next())) continue;
            ++$$7;
        }
    }

    private void scheduleUnload(long p_140182_, ChunkHolder p_140183_) {
        ((CompletableFuture)p_140183_.getSaveSyncFuture().thenRunAsync(() -> {
            if (!p_140183_.isReadyForSaving()) {
                this.scheduleUnload(p_140182_, p_140183_);
                return;
            }
            ChunkAccess $$2 = p_140183_.getLatestChunk();
            if (this.pendingUnloads.remove(p_140182_, (Object)p_140183_) && $$2 != null) {
                if ($$2 instanceof LevelChunk) {
                    LevelChunk $$3 = (LevelChunk)$$2;
                    $$3.setLoaded(false);
                }
                this.save($$2);
                if ($$2 instanceof LevelChunk) {
                    LevelChunk $$4 = (LevelChunk)$$2;
                    this.level.unload($$4);
                }
                this.lightEngine.updateChunkStatus($$2.getPos());
                this.lightEngine.tryScheduleUpdate();
                this.progressListener.onStatusChange($$2.getPos(), null);
                this.chunkSaveCooldowns.remove($$2.getPos().toLong());
            }
        }, this.unloadQueue::add)).whenComplete((p_347052_, p_347053_) -> {
            if (p_347053_ != null) {
                LOGGER.error("Failed to save chunk {}", (Object)p_140183_.getPos(), p_347053_);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos p_140418_) {
        return ((CompletableFuture)((CompletableFuture)this.readChunk(p_140418_).thenApply(p_214925_ -> p_214925_.filter(p_214928_ -> {
            boolean $$2 = ChunkMap.isChunkDataValid(p_214928_);
            if (!$$2) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)p_140418_);
            }
            return $$2;
        }))).thenApplyAsync(p_351774_ -> {
            this.level.getProfiler().incrementCounter("chunkLoad");
            if (p_351774_.isPresent()) {
                ProtoChunk $$2 = ChunkSerializer.read(this.level, this.poiManager, this.storageInfo(), p_140418_, (CompoundTag)p_351774_.get());
                this.markPosition(p_140418_, ((ChunkAccess)$$2).getPersistedStatus().getChunkType());
                return $$2;
            }
            return this.createEmptyChunk(p_140418_);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(p_329919_ -> this.handleChunkLoadFailure((Throwable)p_329919_, p_140418_), (Executor)this.mainThreadExecutor);
    }

    private static boolean isChunkDataValid(CompoundTag p_214941_) {
        return p_214941_.contains("Status", 8);
    }

    private ChunkAccess handleChunkLoadFailure(Throwable p_214902_, ChunkPos p_214903_) {
        boolean $$7;
        Throwable throwable;
        Throwable $$3;
        if (p_214902_ instanceof CompletionException) {
            CompletionException $$2 = (CompletionException)p_214902_;
            v0 = $$2.getCause();
        } else {
            v0 = $$3 = p_214902_;
        }
        if ($$3 instanceof ReportedException) {
            ReportedException $$4 = (ReportedException)$$3;
            throwable = $$4.getCause();
        } else {
            throwable = $$3;
        }
        Throwable $$5 = throwable;
        boolean $$6 = $$5 instanceof Error;
        boolean bl = $$7 = $$5 instanceof IOException || $$5 instanceof NbtException;
        if (!$$6) {
            if (!$$7) {
                // empty if block
            }
        } else {
            CrashReport $$8 = CrashReport.forThrowable(p_214902_, "Exception loading chunk");
            CrashReportCategory $$9 = $$8.addCategory("Chunk being loaded");
            $$9.setDetail("pos", p_214903_);
            this.markPositionReplaceable(p_214903_);
            throw new ReportedException($$8);
        }
        this.level.getServer().reportChunkLoadFailure($$5, this.storageInfo(), p_214903_);
        return this.createEmptyChunk(p_214903_);
    }

    private ChunkAccess createEmptyChunk(ChunkPos p_214962_) {
        this.markPositionReplaceable(p_214962_);
        return new ProtoChunk(p_214962_, UpgradeData.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos p_140423_) {
        this.chunkTypeCache.put(p_140423_.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos p_140230_, ChunkType p_332120_) {
        return this.chunkTypeCache.put(p_140230_.toLong(), p_332120_ == ChunkType.PROTOCHUNK ? (byte)-1 : 1);
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long p_347661_) {
        ChunkHolder $$1 = (ChunkHolder)this.updatingChunkMap.get(p_347661_);
        $$1.increaseGenerationRefCount();
        return $$1;
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder p_347698_) {
        p_347698_.decreaseGenerationRefCount();
    }

    @Override
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder p_347627_, ChunkStep p_347638_, StaticCache2D<GenerationChunkHolder> p_347552_) {
        ChunkPos $$3 = p_347627_.getPos();
        if (p_347638_.targetStatus() == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad($$3);
        }
        try {
            GenerationChunkHolder $$4 = p_347552_.get($$3.x, $$3.z);
            ChunkAccess $$5 = $$4.getChunkIfPresentUnchecked(p_347638_.targetStatus().getParent());
            if ($$5 == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            CompletableFuture<ChunkAccess> $$6 = p_347638_.apply(this.worldGenContext, p_347552_, $$5);
            this.progressListener.onStatusChange($$3, p_347638_.targetStatus());
            return $$6;
        }
        catch (Exception $$7) {
            $$7.getStackTrace();
            CrashReport $$8 = CrashReport.forThrowable($$7, "Exception generating new chunk");
            CrashReportCategory $$9 = $$8.addCategory("Chunk to be generated");
            $$9.setDetail("Status being generated", () -> p_347638_.targetStatus().getName());
            $$9.setDetail("Location", String.format(Locale.ROOT, "%d,%d", $$3.x, $$3.z));
            $$9.setDetail("Position hash", ChunkPos.asLong($$3.x, $$3.z));
            $$9.setDetail("Generator", this.generator());
            this.mainThreadExecutor.execute(() -> {
                throw new ReportedException($$8);
            });
            throw new ReportedException($$8);
        }
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus p_347605_, ChunkPos p_347675_) {
        ChunkGenerationTask $$2 = ChunkGenerationTask.create(this, p_347605_, p_347675_);
        this.pendingGenerationTasks.add($$2);
        return $$2;
    }

    private void runGenerationTask(ChunkGenerationTask p_347721_) {
        this.worldgenMailbox.tell(ChunkTaskPriorityQueueSorter.message(p_347721_.getCenter(), () -> {
            CompletableFuture<?> $$1 = p_347721_.runUntilWait();
            if ($$1 == null) {
                return;
            }
            $$1.thenRun(() -> this.runGenerationTask(p_347721_));
        }));
    }

    @Override
    public void runGenerationTasks() {
        this.pendingGenerationTasks.forEach(this::runGenerationTask);
        this.pendingGenerationTasks.clear();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder p_143054_) {
        CompletableFuture<ChunkResult<List<ChunkAccess>>> $$1 = this.getChunkRangeFuture(p_143054_, 1, p_329920_ -> ChunkStatus.FULL);
        CompletionStage $$2 = ((CompletableFuture)$$1.thenApplyAsync(p_329912_ -> p_329912_.map(p_293806_ -> (LevelChunk)p_293806_.get(p_293806_.size() / 2)), p_347057_ -> this.mainThreadMailbox.tell(ChunkTaskPriorityQueueSorter.message((GenerationChunkHolder)p_143054_, p_347057_)))).thenApplyAsync(p_329924_ -> p_329924_.ifSuccess(p_347050_ -> {
            p_347050_.postProcessGeneration();
            this.level.startTickingChunk((LevelChunk)p_347050_);
            CompletableFuture<?> $$2 = p_143054_.getSendSyncFuture();
            if ($$2.isDone()) {
                this.onChunkReadyToSend((LevelChunk)p_347050_);
            } else {
                $$2.thenAcceptAsync(p_300774_ -> this.onChunkReadyToSend((LevelChunk)p_347050_), (Executor)this.mainThreadExecutor);
            }
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)$$2).handle((p_331041_, p_287365_) -> {
            this.tickingGenerated.getAndIncrement();
            return null;
        });
        return $$2;
    }

    private void onChunkReadyToSend(LevelChunk p_296003_) {
        ChunkPos $$1 = p_296003_.getPos();
        for (ServerPlayer $$2 : this.playerMap.getAllPlayers()) {
            if (!$$2.getChunkTrackingView().contains($$1)) continue;
            ChunkMap.markChunkPendingToSend($$2, p_296003_);
        }
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder p_143110_) {
        return this.getChunkRangeFuture(p_143110_, 1, ChunkLevel::getStatusAroundFullChunk).thenApplyAsync(p_329940_ -> p_329940_.map(p_203092_ -> (LevelChunk)p_203092_.get(p_203092_.size() / 2)), p_347047_ -> this.mainThreadMailbox.tell(ChunkTaskPriorityQueueSorter.message((GenerationChunkHolder)p_143110_, p_347047_)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder p_198875_) {
        if (!p_198875_.wasAccessibleSinceLastSave() || !p_198875_.isReadyForSaving()) {
            return false;
        }
        ChunkAccess $$1 = p_198875_.getLatestChunk();
        if ($$1 instanceof ImposterProtoChunk || $$1 instanceof LevelChunk) {
            long $$2 = $$1.getPos().toLong();
            long $$3 = this.chunkSaveCooldowns.getOrDefault($$2, -1L);
            long $$4 = System.currentTimeMillis();
            if ($$4 < $$3) {
                return false;
            }
            boolean $$5 = this.save($$1);
            p_198875_.refreshAccessibility();
            if ($$5) {
                this.chunkSaveCooldowns.put($$2, $$4 + 10000L);
            }
            return $$5;
        }
        return false;
    }

    private boolean save(ChunkAccess p_140259_) {
        this.poiManager.flush(p_140259_.getPos());
        if (!p_140259_.isUnsaved()) {
            return false;
        }
        p_140259_.setUnsaved(false);
        ChunkPos $$1 = p_140259_.getPos();
        try {
            ChunkStatus $$2 = p_140259_.getPersistedStatus();
            if ($$2.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull($$1)) {
                    return false;
                }
                if ($$2 == ChunkStatus.EMPTY && p_140259_.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            this.level.getProfiler().incrementCounter("chunkSave");
            CompoundTag $$3 = ChunkSerializer.write(this.level, p_140259_);
            this.write($$1, $$3).exceptionally(p_351776_ -> {
                this.level.getServer().reportChunkSaveFailure((Throwable)p_351776_, this.storageInfo(), $$1);
                return null;
            });
            this.markPosition($$1, $$2.getChunkType());
            return true;
        }
        catch (Exception $$4) {
            this.level.getServer().reportChunkSaveFailure($$4, this.storageInfo(), $$1);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isExistingChunkFull(ChunkPos p_140426_) {
        void $$4;
        byte $$1 = this.chunkTypeCache.get(p_140426_.toLong());
        if ($$1 != 0) {
            return $$1 == 1;
        }
        try {
            CompoundTag $$2 = this.readChunk(p_140426_).join().orElse(null);
            if ($$2 == null) {
                this.markPositionReplaceable(p_140426_);
                return false;
            }
        }
        catch (Exception $$3) {
            LOGGER.error("Failed to read chunk {}", (Object)p_140426_, (Object)$$3);
            this.markPositionReplaceable(p_140426_);
            return false;
        }
        ChunkType $$5 = ChunkSerializer.getChunkTypeFromTag((CompoundTag)$$4);
        return this.markPosition(p_140426_, $$5) == 1;
    }

    protected void setServerViewDistance(int p_295758_) {
        int $$1 = Mth.clamp(p_295758_, 2, 32);
        if ($$1 != this.serverViewDistance) {
            this.serverViewDistance = $$1;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (ServerPlayer $$2 : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking($$2);
            }
        }
    }

    int getPlayerViewDistance(ServerPlayer p_295024_) {
        return Mth.clamp(p_295024_.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(ServerPlayer p_294638_, ChunkPos p_296183_) {
        LevelChunk $$2 = this.getChunkToSend(p_296183_.toLong());
        if ($$2 != null) {
            ChunkMap.markChunkPendingToSend(p_294638_, $$2);
        }
    }

    private static void markChunkPendingToSend(ServerPlayer p_295834_, LevelChunk p_296281_) {
        p_295834_.connection.chunkSender.markChunkPendingToSend(p_296281_);
    }

    private static void dropChunk(ServerPlayer p_294215_, ChunkPos p_294758_) {
        p_294215_.connection.chunkSender.dropChunk(p_294215_, p_294758_);
    }

    @Nullable
    public LevelChunk getChunkToSend(long p_300929_) {
        ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_300929_);
        if ($$1 == null) {
            return null;
        }
        return $$1.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public net.minecraft.server.level.DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer p_140275_) throws IOException {
        CsvOutput $$1 = CsvOutput.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(p_140275_);
        TickingTracker $$2 = this.distanceManager.tickingTracker();
        for (Long2ObjectMap.Entry $$3 : this.visibleChunkMap.long2ObjectEntrySet()) {
            long $$4 = $$3.getLongKey();
            ChunkPos $$5 = new ChunkPos($$4);
            ChunkHolder $$6 = (ChunkHolder)$$3.getValue();
            Optional<ChunkAccess> $$7 = Optional.ofNullable($$6.getLatestChunk());
            Optional<Object> $$8 = $$7.flatMap(p_214932_ -> p_214932_ instanceof LevelChunk ? Optional.of((LevelChunk)p_214932_) : Optional.empty());
            $$1.writeRow($$5.x, $$5.z, $$6.getTicketLevel(), $$7.isPresent(), $$7.map(ChunkAccess::getPersistedStatus).orElse(null), $$8.map(LevelChunk::getFullStatus).orElse(null), ChunkMap.printFuture($$6.getFullChunkFuture()), ChunkMap.printFuture($$6.getTickingChunkFuture()), ChunkMap.printFuture($$6.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString($$4), this.anyPlayerCloseEnoughForSpawning($$5), $$8.map(p_214953_ -> p_214953_.getBlockEntities().size()).orElse(0), $$2.getTicketDebugString($$4), $$2.getLevel($$4), $$8.map(p_214946_ -> p_214946_.getBlockTicks().count()).orElse(0), $$8.map(p_214937_ -> p_214937_.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> p_140279_) {
        try {
            ChunkResult $$1 = p_140279_.getNow(null);
            if ($$1 != null) {
                return $$1.isSuccess() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException $$2) {
            return "failed " + $$2.getCause().getMessage();
        }
        catch (CancellationException $$3) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos p_214964_) {
        return this.read(p_214964_).thenApplyAsync(p_214907_ -> p_214907_.map(this::upgradeChunkTag), (Executor)Util.backgroundExecutor());
    }

    private CompoundTag upgradeChunkTag(CompoundTag p_214948_) {
        return this.upgradeChunkTag(this.level.dimension(), this.overworldDataStorage, p_214948_, this.generator().getTypeNameForDataFixer());
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos p_183880_) {
        if (!this.distanceManager.hasPlayersNearby(p_183880_.toLong())) {
            return false;
        }
        for (ServerPlayer $$1 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning($$1, p_183880_)) continue;
            return true;
        }
        return false;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos p_183889_) {
        long $$1 = p_183889_.toLong();
        if (!this.distanceManager.hasPlayersNearby($$1)) {
            return List.of();
        }
        ImmutableList.Builder $$2 = ImmutableList.builder();
        for (ServerPlayer $$3 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning($$3, p_183889_)) continue;
            $$2.add((Object)$$3);
        }
        return $$2.build();
    }

    private boolean playerIsCloseEnoughForSpawning(ServerPlayer p_183752_, ChunkPos p_183753_) {
        if (p_183752_.isSpectator()) {
            return false;
        }
        double $$2 = ChunkMap.euclideanDistanceSquared(p_183753_, p_183752_);
        return $$2 < 16384.0;
    }

    private boolean skipPlayer(ServerPlayer p_140330_) {
        return p_140330_.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(ServerPlayer p_140193_, boolean p_140194_) {
        boolean $$2 = this.skipPlayer(p_140193_);
        boolean $$3 = this.playerMap.ignoredOrUnknown(p_140193_);
        if (p_140194_) {
            this.playerMap.addPlayer(p_140193_, $$2);
            this.updatePlayerPos(p_140193_);
            if (!$$2) {
                this.distanceManager.addPlayer(SectionPos.of(p_140193_), p_140193_);
            }
            p_140193_.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking(p_140193_);
        } else {
            SectionPos $$4 = p_140193_.getLastSectionPos();
            this.playerMap.removePlayer(p_140193_);
            if (!$$3) {
                this.distanceManager.removePlayer($$4, p_140193_);
            }
            this.applyChunkTrackingView(p_140193_, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(ServerPlayer p_140374_) {
        SectionPos $$1 = SectionPos.of(p_140374_);
        p_140374_.setLastSectionPos($$1);
    }

    public void move(ServerPlayer p_140185_) {
        boolean $$6;
        for (TrackedEntity $$1 : this.entityMap.values()) {
            if ($$1.entity == p_140185_) {
                $$1.updatePlayers(this.level.players());
                continue;
            }
            $$1.updatePlayer(p_140185_);
        }
        SectionPos $$2 = p_140185_.getLastSectionPos();
        SectionPos $$3 = SectionPos.of(p_140185_);
        boolean $$4 = this.playerMap.ignored(p_140185_);
        boolean $$5 = this.skipPlayer(p_140185_);
        boolean bl = $$6 = $$2.asLong() != $$3.asLong();
        if ($$6 || $$4 != $$5) {
            this.updatePlayerPos(p_140185_);
            if (!$$4) {
                this.distanceManager.removePlayer($$2, p_140185_);
            }
            if (!$$5) {
                this.distanceManager.addPlayer($$3, p_140185_);
            }
            if (!$$4 && $$5) {
                this.playerMap.ignorePlayer(p_140185_);
            }
            if ($$4 && !$$5) {
                this.playerMap.unIgnorePlayer(p_140185_);
            }
            this.updateChunkTracking(p_140185_);
        }
    }

    private void updateChunkTracking(ServerPlayer p_183755_) {
        ChunkTrackingView.Positioned $$3;
        ChunkPos $$1 = p_183755_.chunkPosition();
        int $$2 = this.getPlayerViewDistance(p_183755_);
        ChunkTrackingView chunkTrackingView = p_183755_.getChunkTrackingView();
        if (chunkTrackingView instanceof ChunkTrackingView.Positioned && ($$3 = (ChunkTrackingView.Positioned)chunkTrackingView).center().equals($$1) && $$3.viewDistance() == $$2) {
            return;
        }
        this.applyChunkTrackingView(p_183755_, ChunkTrackingView.of($$1, $$2));
    }

    private void applyChunkTrackingView(ServerPlayer p_294188_, ChunkTrackingView p_294174_) {
        if (p_294188_.level() != this.level) {
            return;
        }
        ChunkTrackingView $$2 = p_294188_.getChunkTrackingView();
        if (p_294174_ instanceof ChunkTrackingView.Positioned) {
            ChunkTrackingView.Positioned $$4;
            ChunkTrackingView.Positioned $$3 = (ChunkTrackingView.Positioned)p_294174_;
            if (!($$2 instanceof ChunkTrackingView.Positioned) || !($$4 = (ChunkTrackingView.Positioned)$$2).center().equals($$3.center())) {
                p_294188_.connection.send(new ClientboundSetChunkCacheCenterPacket($$3.center().x, $$3.center().z));
            }
        }
        ChunkTrackingView.difference($$2, p_294174_, p_293802_ -> this.markChunkPendingToSend(p_294188_, (ChunkPos)p_293802_), p_293800_ -> ChunkMap.dropChunk(p_294188_, p_293800_));
        p_294188_.setChunkTrackingView(p_294174_);
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos p_183801_, boolean p_183802_) {
        Set<ServerPlayer> $$2 = this.playerMap.getAllPlayers();
        ImmutableList.Builder $$3 = ImmutableList.builder();
        for (ServerPlayer $$4 : $$2) {
            if ((!p_183802_ || !this.isChunkOnTrackedBorder($$4, p_183801_.x, p_183801_.z)) && (p_183802_ || !this.isChunkTracked($$4, p_183801_.x, p_183801_.z))) continue;
            $$3.add((Object)$$4);
        }
        return $$3.build();
    }

    protected void addEntity(Entity p_140200_) {
        if (p_140200_ instanceof EnderDragonPart) {
            return;
        }
        EntityType<?> $$1 = p_140200_.getType();
        int $$2 = $$1.clientTrackingRange() * 16;
        if ($$2 == 0) {
            return;
        }
        int $$3 = $$1.updateInterval();
        if (this.entityMap.containsKey(p_140200_.getId())) {
            throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
        }
        TrackedEntity $$4 = new TrackedEntity(p_140200_, $$2, $$3, $$1.trackDeltas());
        this.entityMap.put(p_140200_.getId(), (Object)$$4);
        $$4.updatePlayers(this.level.players());
        if (p_140200_ instanceof ServerPlayer) {
            ServerPlayer $$5 = (ServerPlayer)p_140200_;
            this.updatePlayerStatus($$5, true);
            for (TrackedEntity $$6 : this.entityMap.values()) {
                if ($$6.entity == $$5) continue;
                $$6.updatePlayer($$5);
            }
        }
    }

    protected void removeEntity(Entity p_140332_) {
        TrackedEntity $$3;
        if (p_140332_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_140332_;
            this.updatePlayerStatus($$1, false);
            for (TrackedEntity $$2 : this.entityMap.values()) {
                $$2.removePlayer($$1);
            }
        }
        if (($$3 = (TrackedEntity)this.entityMap.remove(p_140332_.getId())) != null) {
            $$3.broadcastRemoved();
        }
    }

    protected void tick() {
        for (ServerPlayer $$0 : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking($$0);
        }
        ArrayList $$1 = Lists.newArrayList();
        List<ServerPlayer> $$2 = this.level.players();
        for (TrackedEntity $$3 : this.entityMap.values()) {
            boolean $$6;
            SectionPos $$4 = $$3.lastSectionPos;
            SectionPos $$5 = SectionPos.of($$3.entity);
            boolean bl = $$6 = !Objects.equals($$4, $$5);
            if ($$6) {
                $$3.updatePlayers($$2);
                Entity $$7 = $$3.entity;
                if ($$7 instanceof ServerPlayer) {
                    $$1.add((ServerPlayer)$$7);
                }
                $$3.lastSectionPos = $$5;
            }
            if (!$$6 && !this.distanceManager.inEntityTickingRange($$5.chunk().toLong())) continue;
            $$3.serverEntity.sendChanges();
        }
        if (!$$1.isEmpty()) {
            for (TrackedEntity $$8 : this.entityMap.values()) {
                $$8.updatePlayers($$1);
            }
        }
    }

    public void broadcast(Entity p_140202_, Packet<?> p_140203_) {
        TrackedEntity $$2 = (TrackedEntity)this.entityMap.get(p_140202_.getId());
        if ($$2 != null) {
            $$2.broadcast(p_140203_);
        }
    }

    protected void broadcastAndSend(Entity p_140334_, Packet<?> p_140335_) {
        TrackedEntity $$2 = (TrackedEntity)this.entityMap.get(p_140334_.getId());
        if ($$2 != null) {
            $$2.broadcastAndSend(p_140335_);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> p_275577_) {
        HashMap<ServerPlayer, List> $$1 = new HashMap<ServerPlayer, List>();
        for (ChunkAccess $$2 : p_275577_) {
            LevelChunk $$6;
            ChunkPos $$3 = $$2.getPos();
            if ($$2 instanceof LevelChunk) {
                LevelChunk $$4;
                LevelChunk $$5 = $$4 = (LevelChunk)$$2;
            } else {
                $$6 = this.level.getChunk($$3.x, $$3.z);
            }
            for (ServerPlayer $$7 : this.getPlayers($$3, false)) {
                $$1.computeIfAbsent($$7, p_274834_ -> new ArrayList()).add($$6);
            }
        }
        $$1.forEach((p_293803_, p_293804_) -> p_293803_.connection.send(ClientboundChunksBiomesPacket.forChunks(p_293804_)));
    }

    protected PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos p_287612_, FullChunkStatus p_287685_) {
        this.chunkStatusListener.onChunkStatusChange(p_287612_, p_287685_);
    }

    public void waitForLightBeforeSending(ChunkPos p_301194_, int p_301130_) {
        int $$2 = p_301130_ + 1;
        ChunkPos.rangeClosed(p_301194_, $$2).forEach(p_300775_ -> {
            ChunkHolder $$1 = this.getVisibleChunkIfPresent(p_300775_.toLong());
            if ($$1 != null) {
                $$1.addSendDependency(this.lightEngine.waitForPendingTasks(p_300775_.x, p_300775_.z));
            }
        });
    }

    class DistanceManager
    extends net.minecraft.server.level.DistanceManager {
        protected DistanceManager(Executor p_140459_, Executor p_140460_) {
            super(p_140459_, p_140460_);
        }

        @Override
        protected boolean isChunkToRemove(long p_140462_) {
            return ChunkMap.this.toDrop.contains(p_140462_);
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long p_140469_) {
            return ChunkMap.this.getUpdatingChunkIfPresent(p_140469_);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long p_140464_, int p_140465_, @Nullable ChunkHolder p_140466_, int p_140467_) {
            return ChunkMap.this.updateChunkScheduling(p_140464_, p_140465_, p_140466_, p_140467_);
        }
    }

    class TrackedEntity {
        final ServerEntity serverEntity;
        final Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        private final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public TrackedEntity(Entity p_140478_, int p_140479_, int p_140480_, boolean p_140481_) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, p_140478_, p_140480_, p_140481_, this::broadcast);
            this.entity = p_140478_;
            this.range = p_140479_;
            this.lastSectionPos = SectionPos.of(p_140478_);
        }

        public boolean equals(Object p_140506_) {
            if (p_140506_ instanceof TrackedEntity) {
                return ((TrackedEntity)p_140506_).entity.getId() == this.entity.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> p_140490_) {
            for (ServerPlayerConnection $$1 : this.seenBy) {
                $$1.send(p_140490_);
            }
        }

        public void broadcastAndSend(Packet<?> p_140500_) {
            this.broadcast(p_140500_);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send(p_140500_);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection $$0 : this.seenBy) {
                this.serverEntity.removePairing($$0.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer p_140486_) {
            if (this.seenBy.remove(p_140486_.connection)) {
                this.serverEntity.removePairing(p_140486_);
            }
        }

        public void updatePlayer(ServerPlayer p_140498_) {
            boolean $$6;
            if (p_140498_ == this.entity) {
                return;
            }
            Vec3 $$1 = p_140498_.position().subtract(this.entity.position());
            int $$2 = ChunkMap.this.getPlayerViewDistance(p_140498_);
            double $$4 = $$1.x * $$1.x + $$1.z * $$1.z;
            double $$3 = Math.min(this.getEffectiveRange(), $$2 * 16);
            double $$5 = $$3 * $$3;
            boolean bl = $$6 = $$4 <= $$5 && this.entity.broadcastToPlayer(p_140498_) && ChunkMap.this.isChunkTracked(p_140498_, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
            if ($$6) {
                if (this.seenBy.add(p_140498_.connection)) {
                    this.serverEntity.addPairing(p_140498_);
                }
            } else if (this.seenBy.remove(p_140498_.connection)) {
                this.serverEntity.removePairing(p_140498_);
            }
        }

        private int scaledRange(int p_140484_) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance(p_140484_);
        }

        private int getEffectiveRange() {
            int $$0 = this.range;
            for (Entity $$1 : this.entity.getIndirectPassengers()) {
                int $$2 = $$1.getType().clientTrackingRange() * 16;
                if ($$2 <= $$0) continue;
                $$0 = $$2;
            }
            return this.scaledRange($$0);
        }

        public void updatePlayers(List<ServerPlayer> p_140488_) {
            for (ServerPlayer $$1 : p_140488_) {
                this.updatePlayer($$1);
            }
        }
    }
}

