/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class MobEffectIdFix
extends DataFix {
    private static final Int2ObjectMap<String> ID_MAP = (Int2ObjectMap)Util.make(new Int2ObjectOpenHashMap(), p_298903_ -> {
        p_298903_.put(1, (Object)"minecraft:speed");
        p_298903_.put(2, (Object)"minecraft:slowness");
        p_298903_.put(3, (Object)"minecraft:haste");
        p_298903_.put(4, (Object)"minecraft:mining_fatigue");
        p_298903_.put(5, (Object)"minecraft:strength");
        p_298903_.put(6, (Object)"minecraft:instant_health");
        p_298903_.put(7, (Object)"minecraft:instant_damage");
        p_298903_.put(8, (Object)"minecraft:jump_boost");
        p_298903_.put(9, (Object)"minecraft:nausea");
        p_298903_.put(10, (Object)"minecraft:regeneration");
        p_298903_.put(11, (Object)"minecraft:resistance");
        p_298903_.put(12, (Object)"minecraft:fire_resistance");
        p_298903_.put(13, (Object)"minecraft:water_breathing");
        p_298903_.put(14, (Object)"minecraft:invisibility");
        p_298903_.put(15, (Object)"minecraft:blindness");
        p_298903_.put(16, (Object)"minecraft:night_vision");
        p_298903_.put(17, (Object)"minecraft:hunger");
        p_298903_.put(18, (Object)"minecraft:weakness");
        p_298903_.put(19, (Object)"minecraft:poison");
        p_298903_.put(20, (Object)"minecraft:wither");
        p_298903_.put(21, (Object)"minecraft:health_boost");
        p_298903_.put(22, (Object)"minecraft:absorption");
        p_298903_.put(23, (Object)"minecraft:saturation");
        p_298903_.put(24, (Object)"minecraft:glowing");
        p_298903_.put(25, (Object)"minecraft:levitation");
        p_298903_.put(26, (Object)"minecraft:luck");
        p_298903_.put(27, (Object)"minecraft:unluck");
        p_298903_.put(28, (Object)"minecraft:slow_falling");
        p_298903_.put(29, (Object)"minecraft:conduit_power");
        p_298903_.put(30, (Object)"minecraft:dolphins_grace");
        p_298903_.put(31, (Object)"minecraft:bad_omen");
        p_298903_.put(32, (Object)"minecraft:hero_of_the_village");
        p_298903_.put(33, (Object)"minecraft:darkness");
    });
    private static final Set<String> MOB_EFFECT_INSTANCE_CARRIER_ITEMS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public MobEffectIdFix(Schema p_298197_) {
        super(p_298197_, false);
    }

    private static <T> Optional<Dynamic<T>> getAndConvertMobEffectId(Dynamic<T> p_299296_, String p_298445_) {
        return p_299296_.get(p_298445_).asNumber().result().map(p_298383_ -> (String)ID_MAP.get(p_298383_.intValue())).map(arg_0 -> p_299296_.createString(arg_0));
    }

    private static <T> Dynamic<T> updateMobEffectIdField(Dynamic<T> p_298948_, String p_299234_, Dynamic<T> p_298832_, String p_298487_) {
        Optional<Dynamic<T>> $$4 = MobEffectIdFix.getAndConvertMobEffectId(p_298948_, p_299234_);
        return p_298832_.replaceField(p_299234_, p_298487_, $$4);
    }

    private static <T> Dynamic<T> updateMobEffectIdField(Dynamic<T> p_299001_, String p_298420_, String p_299179_) {
        return MobEffectIdFix.updateMobEffectIdField(p_299001_, p_298420_, p_299001_, p_299179_);
    }

    private static <T> Dynamic<T> updateMobEffectInstance(Dynamic<T> p_298320_) {
        p_298320_ = MobEffectIdFix.updateMobEffectIdField(p_298320_, "Id", "id");
        p_298320_ = p_298320_.renameField("Ambient", "ambient");
        p_298320_ = p_298320_.renameField("Amplifier", "amplifier");
        p_298320_ = p_298320_.renameField("Duration", "duration");
        p_298320_ = p_298320_.renameField("ShowParticles", "show_particles");
        p_298320_ = p_298320_.renameField("ShowIcon", "show_icon");
        Optional<Dynamic> $$1 = p_298320_.get("HiddenEffect").result().map(MobEffectIdFix::updateMobEffectInstance);
        return p_298320_.replaceField("HiddenEffect", "hidden_effect", $$1);
    }

    private static <T> Dynamic<T> updateMobEffectInstanceList(Dynamic<T> p_299048_, String p_298254_, String p_298643_) {
        Optional<Dynamic> $$3 = p_299048_.get(p_298254_).asStreamOpt().result().map(p_298291_ -> p_299048_.createList(p_298291_.map(MobEffectIdFix::updateMobEffectInstance)));
        return p_299048_.replaceField(p_298254_, p_298643_, $$3);
    }

    private static <T> Dynamic<T> updateSuspiciousStewEntry(Dynamic<T> p_298902_, Dynamic<T> p_299113_) {
        p_299113_ = MobEffectIdFix.updateMobEffectIdField(p_298902_, "EffectId", p_299113_, "id");
        Optional $$2 = p_298902_.get("EffectDuration").result();
        return p_299113_.replaceField("EffectDuration", "duration", $$2);
    }

    private static <T> Dynamic<T> updateSuspiciousStewEntry(Dynamic<T> p_298873_) {
        return MobEffectIdFix.updateSuspiciousStewEntry(p_298873_, p_298873_);
    }

    private Typed<?> updateNamedChoice(Typed<?> p_298304_, DSL.TypeReference p_298928_, String p_298718_, Function<Dynamic<?>, Dynamic<?>> p_298931_) {
        Type $$4 = this.getInputSchema().getChoiceType(p_298928_, p_298718_);
        Type $$5 = this.getOutputSchema().getChoiceType(p_298928_, p_298718_);
        return p_298304_.updateTyped(DSL.namedChoice((String)p_298718_, (Type)$$4), $$5, p_298322_ -> p_298322_.update(DSL.remainderFinder(), p_298931_));
    }

    private TypeRewriteRule blockEntityFixer() {
        Type $$0 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        return this.fixTypeEverywhereTyped("BlockEntityMobEffectIdFix", $$0, p_299097_ -> {
            p_299097_ = this.updateNamedChoice((Typed<?>)p_299097_, References.BLOCK_ENTITY, "minecraft:beacon", p_298966_ -> {
                p_298966_ = MobEffectIdFix.updateMobEffectIdField(p_298966_, "Primary", "primary_effect");
                return MobEffectIdFix.updateMobEffectIdField(p_298966_, "Secondary", "secondary_effect");
            });
            return p_299097_;
        });
    }

    private static <T> Dynamic<T> fixMooshroomTag(Dynamic<T> p_298470_) {
        Dynamic $$1 = p_298470_.emptyMap();
        Dynamic<T> $$2 = MobEffectIdFix.updateSuspiciousStewEntry(p_298470_, $$1);
        if (!$$2.equals((Object)$$1)) {
            p_298470_ = p_298470_.set("stew_effects", p_298470_.createList(Stream.of($$2)));
        }
        return p_298470_.remove("EffectId").remove("EffectDuration");
    }

    private static <T> Dynamic<T> fixArrowTag(Dynamic<T> p_299026_) {
        return MobEffectIdFix.updateMobEffectInstanceList(p_299026_, "CustomPotionEffects", "custom_potion_effects");
    }

    private static <T> Dynamic<T> fixAreaEffectCloudTag(Dynamic<T> p_298539_) {
        return MobEffectIdFix.updateMobEffectInstanceList(p_298539_, "Effects", "effects");
    }

    private static Dynamic<?> updateLivingEntityTag(Dynamic<?> p_299145_) {
        return MobEffectIdFix.updateMobEffectInstanceList(p_299145_, "ActiveEffects", "active_effects");
    }

    private TypeRewriteRule entityFixer() {
        Type $$0 = this.getInputSchema().getType(References.ENTITY);
        return this.fixTypeEverywhereTyped("EntityMobEffectIdFix", $$0, p_298626_ -> {
            p_298626_ = this.updateNamedChoice((Typed<?>)p_298626_, References.ENTITY, "minecraft:mooshroom", MobEffectIdFix::fixMooshroomTag);
            p_298626_ = this.updateNamedChoice((Typed<?>)p_298626_, References.ENTITY, "minecraft:arrow", MobEffectIdFix::fixArrowTag);
            p_298626_ = this.updateNamedChoice((Typed<?>)p_298626_, References.ENTITY, "minecraft:area_effect_cloud", MobEffectIdFix::fixAreaEffectCloudTag);
            p_298626_ = p_298626_.update(DSL.remainderFinder(), MobEffectIdFix::updateLivingEntityTag);
            return p_298626_;
        });
    }

    private TypeRewriteRule playerFixer() {
        Type $$0 = this.getInputSchema().getType(References.PLAYER);
        return this.fixTypeEverywhereTyped("PlayerMobEffectIdFix", $$0, p_300792_ -> p_300792_.update(DSL.remainderFinder(), MobEffectIdFix::updateLivingEntityTag));
    }

    private static <T> Dynamic<T> fixSuspiciousStewTag(Dynamic<T> p_298546_) {
        Optional<Dynamic> $$1 = p_298546_.get("Effects").asStreamOpt().result().map(p_299036_ -> p_298546_.createList(p_299036_.map(MobEffectIdFix::updateSuspiciousStewEntry)));
        return p_298546_.replaceField("Effects", "effects", $$1);
    }

    private TypeRewriteRule itemStackFixer() {
        OpticFinder $$0 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        Type $$1 = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder $$2 = $$1.findField("tag");
        return this.fixTypeEverywhereTyped("ItemStackMobEffectIdFix", $$1, p_298821_ -> {
            Optional $$3 = p_298821_.getOptional($$0);
            if ($$3.isPresent()) {
                String $$4 = (String)((Pair)$$3.get()).getSecond();
                if ($$4.equals("minecraft:suspicious_stew")) {
                    return p_298821_.updateTyped($$2, p_298520_ -> p_298520_.update(DSL.remainderFinder(), MobEffectIdFix::fixSuspiciousStewTag));
                }
                if (MOB_EFFECT_INSTANCE_CARRIER_ITEMS.contains($$4)) {
                    return p_298821_.updateTyped($$2, p_298705_ -> p_298705_.update(DSL.remainderFinder(), p_298855_ -> MobEffectIdFix.updateMobEffectInstanceList(p_298855_, "CustomPotionEffects", "custom_potion_effects")));
                }
            }
            return p_298821_;
        });
    }

    protected TypeRewriteRule makeRule() {
        return TypeRewriteRule.seq((TypeRewriteRule)this.blockEntityFixer(), (TypeRewriteRule[])new TypeRewriteRule[]{this.entityFixer(), this.playerFixer(), this.itemStackFixer()});
    }
}

