/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.GoAndGiveItemsToTarget;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class AllayAi {
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_DEPOSIT_TARGET = 2.25f;
    private static final float SPEED_MULTIPLIER_WHEN_RETRIEVING_ITEM = 1.75f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.5f;
    private static final int CLOSE_ENOUGH_TO_TARGET = 4;
    private static final int TOO_FAR_FROM_TARGET = 16;
    private static final int MAX_LOOK_DISTANCE = 6;
    private static final int MIN_WAIT_DURATION = 30;
    private static final int MAX_WAIT_DURATION = 60;
    private static final int TIME_TO_FORGET_NOTEBLOCK = 600;
    private static final int DISTANCE_TO_WANTED_ITEM = 32;
    private static final int GIVE_ITEM_TIMEOUT_DURATION = 20;

    protected static Brain<?> makeBrain(Brain<Allay> p_218420_) {
        AllayAi.initCoreActivity(p_218420_);
        AllayAi.initIdleActivity(p_218420_);
        p_218420_.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        p_218420_.setDefaultActivity(Activity.IDLE);
        p_218420_.useDefaultActivity();
        return p_218420_;
    }

    private static void initCoreActivity(Brain<Allay> p_218426_) {
        p_218426_.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Allay>>)ImmutableList.of((Object)new Swim(0.8f), new AnimalPanic(2.5f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Allay> p_218432_) {
        p_218432_.addActivityWithConditions(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Allay>>>)ImmutableList.of((Object)Pair.of((Object)0, GoToWantedItem.create(p_218428_ -> true, 1.75f, true, 32)), (Object)Pair.of((Object)1, new GoAndGiveItemsToTarget(AllayAi::getItemDepositPosition, 2.25f, 20)), (Object)Pair.of((Object)2, StayCloseToTarget.create(AllayAi::getItemDepositPosition, Predicate.not(AllayAi::hasWantedItem), 4, 16, 2.25f)), (Object)Pair.of((Object)3, SetEntityLookTargetSometimes.create(6.0f, UniformInt.of(30, 60))), (Object)Pair.of((Object)4, new RunOne(ImmutableList.of((Object)Pair.of(RandomStroll.fly(1.0f), (Object)2), (Object)Pair.of(SetWalkTargetFromLookTarget.create(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of());
    }

    public static void updateActivity(Allay p_218422_) {
        p_218422_.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.IDLE));
    }

    public static void hearNoteblock(LivingEntity p_218417_, BlockPos p_218418_) {
        Brain<?> $$2 = p_218417_.getBrain();
        GlobalPos $$3 = GlobalPos.of(p_218417_.level().dimension(), p_218418_);
        Optional<GlobalPos> $$4 = $$2.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        if ($$4.isEmpty()) {
            $$2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION, $$3);
            $$2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, 600);
        } else if ($$4.get().equals($$3)) {
            $$2.setMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS, 600);
        }
    }

    private static Optional<PositionTracker> getItemDepositPosition(LivingEntity p_218424_) {
        Brain<?> $$1 = p_218424_.getBrain();
        Optional<GlobalPos> $$2 = $$1.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        if ($$2.isPresent()) {
            GlobalPos $$3 = $$2.get();
            if (AllayAi.shouldDepositItemsAtLikedNoteblock(p_218424_, $$1, $$3)) {
                return Optional.of(new BlockPosTracker($$3.pos().above()));
            }
            $$1.eraseMemory(MemoryModuleType.LIKED_NOTEBLOCK_POSITION);
        }
        return AllayAi.getLikedPlayerPositionTracker(p_218424_);
    }

    private static boolean hasWantedItem(LivingEntity p_273346_) {
        Brain<ItemEntity> $$1 = p_273346_.getBrain();
        return $$1.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
    }

    private static boolean shouldDepositItemsAtLikedNoteblock(LivingEntity p_218413_, Brain<?> p_218414_, GlobalPos p_218415_) {
        Optional<Integer> $$3 = p_218414_.getMemory(MemoryModuleType.LIKED_NOTEBLOCK_COOLDOWN_TICKS);
        Level $$4 = p_218413_.level();
        return $$4.dimension() == p_218415_.dimension() && $$4.getBlockState(p_218415_.pos()).is(Blocks.NOTE_BLOCK) && $$3.isPresent();
    }

    private static Optional<PositionTracker> getLikedPlayerPositionTracker(LivingEntity p_218430_) {
        return AllayAi.getLikedPlayer(p_218430_).map(p_218409_ -> new EntityTracker((Entity)p_218409_, true));
    }

    public static Optional<ServerPlayer> getLikedPlayer(LivingEntity p_218411_) {
        Level $$1 = p_218411_.level();
        if (!$$1.isClientSide() && $$1 instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)$$1;
            Optional<UUID> $$3 = p_218411_.getBrain().getMemory(MemoryModuleType.LIKED_PLAYER);
            if ($$3.isPresent()) {
                Entity $$4 = $$2.getEntity($$3.get());
                if ($$4 instanceof ServerPlayer) {
                    ServerPlayer $$5 = (ServerPlayer)$$4;
                    if (($$5.gameMode.isSurvival() || $$5.gameMode.isCreative()) && $$5.closerThan(p_218411_, 64.0)) {
                        return Optional.of($$5);
                    }
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

