/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public interface LevelReader
extends BlockAndTintGetter,
CollisionGetter,
SignalGetter,
BiomeManager.NoiseBiomeSource {
    @Nullable
    public ChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean hasChunk(int var1, int var2);

    public int getHeight(Heightmap.Types var1, int var2, int var3);

    public int getSkyDarken();

    public BiomeManager getBiomeManager();

    default public Holder<Biome> getBiome(BlockPos p_204167_) {
        return this.getBiomeManager().getBiome(p_204167_);
    }

    default public Stream<BlockState> getBlockStatesIfLoaded(AABB p_46848_) {
        int $$6;
        int $$1 = Mth.floor(p_46848_.minX);
        int $$2 = Mth.floor(p_46848_.maxX);
        int $$3 = Mth.floor(p_46848_.minY);
        int $$4 = Mth.floor(p_46848_.maxY);
        int $$5 = Mth.floor(p_46848_.minZ);
        if (this.hasChunksAt($$1, $$3, $$5, $$2, $$4, $$6 = Mth.floor(p_46848_.maxZ))) {
            return this.getBlockStates(p_46848_);
        }
        return Stream.empty();
    }

    @Override
    default public int getBlockTint(BlockPos p_46836_, ColorResolver p_46837_) {
        return p_46837_.getColor(this.getBiome(p_46836_).value(), p_46836_.getX(), p_46836_.getZ());
    }

    @Override
    default public Holder<Biome> getNoiseBiome(int p_204163_, int p_204164_, int p_204165_) {
        ChunkAccess $$3 = this.getChunk(QuartPos.toSection(p_204163_), QuartPos.toSection(p_204165_), ChunkStatus.BIOMES, false);
        if ($$3 != null) {
            return $$3.getNoiseBiome(p_204163_, p_204164_, p_204165_);
        }
        return this.getUncachedNoiseBiome(p_204163_, p_204164_, p_204165_);
    }

    public Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    public boolean isClientSide();

    @Deprecated
    public int getSeaLevel();

    public DimensionType dimensionType();

    @Override
    default public int getMinBuildHeight() {
        return this.dimensionType().minY();
    }

    @Override
    default public int getHeight() {
        return this.dimensionType().height();
    }

    default public BlockPos getHeightmapPos(Heightmap.Types p_46830_, BlockPos p_46831_) {
        return new BlockPos(p_46831_.getX(), this.getHeight(p_46830_, p_46831_.getX(), p_46831_.getZ()), p_46831_.getZ());
    }

    default public boolean isEmptyBlock(BlockPos p_46860_) {
        return this.getBlockState(p_46860_).isAir();
    }

    default public boolean canSeeSkyFromBelowWater(BlockPos p_46862_) {
        if (p_46862_.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(p_46862_);
        }
        BlockPos $$1 = new BlockPos(p_46862_.getX(), this.getSeaLevel(), p_46862_.getZ());
        if (!this.canSeeSky($$1)) {
            return false;
        }
        $$1 = $$1.below();
        while ($$1.getY() > p_46862_.getY()) {
            BlockState $$2 = this.getBlockState($$1);
            if ($$2.getLightBlock(this, $$1) > 0 && !$$2.liquid()) {
                return false;
            }
            $$1 = $$1.below();
        }
        return true;
    }

    default public float getPathfindingCostFromLightLevels(BlockPos p_220420_) {
        return this.getLightLevelDependentMagicValue(p_220420_) - 0.5f;
    }

    @Deprecated
    default public float getLightLevelDependentMagicValue(BlockPos p_220418_) {
        float $$1 = (float)this.getMaxLocalRawBrightness(p_220418_) / 15.0f;
        float $$2 = $$1 / (4.0f - 3.0f * $$1);
        return Mth.lerp(this.dimensionType().ambientLight(), $$2, 1.0f);
    }

    default public ChunkAccess getChunk(BlockPos p_46866_) {
        return this.getChunk(SectionPos.blockToSectionCoord(p_46866_.getX()), SectionPos.blockToSectionCoord(p_46866_.getZ()));
    }

    default public ChunkAccess getChunk(int p_46807_, int p_46808_) {
        return this.getChunk(p_46807_, p_46808_, ChunkStatus.FULL, true);
    }

    default public ChunkAccess getChunk(int p_46820_, int p_46821_, ChunkStatus p_332007_) {
        return this.getChunk(p_46820_, p_46821_, p_332007_, true);
    }

    @Override
    @Nullable
    default public BlockGetter getChunkForCollisions(int p_46845_, int p_46846_) {
        return this.getChunk(p_46845_, p_46846_, ChunkStatus.EMPTY, false);
    }

    default public boolean isWaterAt(BlockPos p_46802_) {
        return this.getFluidState(p_46802_).is(FluidTags.WATER);
    }

    default public boolean containsAnyLiquid(AABB p_46856_) {
        int $$1 = Mth.floor(p_46856_.minX);
        int $$2 = Mth.ceil(p_46856_.maxX);
        int $$3 = Mth.floor(p_46856_.minY);
        int $$4 = Mth.ceil(p_46856_.maxY);
        int $$5 = Mth.floor(p_46856_.minZ);
        int $$6 = Mth.ceil(p_46856_.maxZ);
        BlockPos.MutableBlockPos $$7 = new BlockPos.MutableBlockPos();
        for (int $$8 = $$1; $$8 < $$2; ++$$8) {
            for (int $$9 = $$3; $$9 < $$4; ++$$9) {
                for (int $$10 = $$5; $$10 < $$6; ++$$10) {
                    BlockState $$11 = this.getBlockState($$7.set($$8, $$9, $$10));
                    if ($$11.getFluidState().isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int getMaxLocalRawBrightness(BlockPos p_46804_) {
        return this.getMaxLocalRawBrightness(p_46804_, this.getSkyDarken());
    }

    default public int getMaxLocalRawBrightness(BlockPos p_46850_, int p_46851_) {
        if (p_46850_.getX() < -30000000 || p_46850_.getZ() < -30000000 || p_46850_.getX() >= 30000000 || p_46850_.getZ() >= 30000000) {
            return 15;
        }
        return this.getRawBrightness(p_46850_, p_46851_);
    }

    @Deprecated
    default public boolean hasChunkAt(int p_151578_, int p_151579_) {
        return this.hasChunk(SectionPos.blockToSectionCoord(p_151578_), SectionPos.blockToSectionCoord(p_151579_));
    }

    @Deprecated
    default public boolean hasChunkAt(BlockPos p_46806_) {
        return this.hasChunkAt(p_46806_.getX(), p_46806_.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(BlockPos p_46833_, BlockPos p_46834_) {
        return this.hasChunksAt(p_46833_.getX(), p_46833_.getY(), p_46833_.getZ(), p_46834_.getX(), p_46834_.getY(), p_46834_.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(int p_46813_, int p_46814_, int p_46815_, int p_46816_, int p_46817_, int p_46818_) {
        if (p_46817_ < this.getMinBuildHeight() || p_46814_ >= this.getMaxBuildHeight()) {
            return false;
        }
        return this.hasChunksAt(p_46813_, p_46815_, p_46816_, p_46818_);
    }

    @Deprecated
    default public boolean hasChunksAt(int p_151573_, int p_151574_, int p_151575_, int p_151576_) {
        int $$4 = SectionPos.blockToSectionCoord(p_151573_);
        int $$5 = SectionPos.blockToSectionCoord(p_151575_);
        int $$6 = SectionPos.blockToSectionCoord(p_151574_);
        int $$7 = SectionPos.blockToSectionCoord(p_151576_);
        for (int $$8 = $$4; $$8 <= $$5; ++$$8) {
            for (int $$9 = $$6; $$9 <= $$7; ++$$9) {
                if (this.hasChunk($$8, $$9)) continue;
                return false;
            }
        }
        return true;
    }

    public RegistryAccess registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<? extends T>> p_249578_) {
        Registry $$1 = this.registryAccess().registryOrThrow(p_249578_);
        return $$1.asLookup().filterFeatures(this.enabledFeatures());
    }
}

