/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChestBlock
extends AbstractChestBlock<ChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<ChestBlock> CODEC = ChestBlock.simpleCodec(p_304364_ -> new ChestBlock((BlockBehaviour.Properties)p_304364_, () -> BlockEntityType.CHEST));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    protected static final int AABB_OFFSET = 1;
    protected static final int AABB_HEIGHT = 14;
    protected static final VoxelShape NORTH_AABB = Block.box(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape EAST_AABB = Block.box(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape AABB = Block.box(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>>(){

        @Override
        public Optional<Container> acceptDouble(ChestBlockEntity p_51591_, ChestBlockEntity p_51592_) {
            return Optional.of(new CompoundContainer(p_51591_, p_51592_));
        }

        @Override
        public Optional<Container> acceptSingle(ChestBlockEntity p_51589_) {
            return Optional.of(p_51589_);
        }

        @Override
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object acceptNone() {
            return this.acceptNone();
        }
    };
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        @Override
        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity p_51604_, final ChestBlockEntity p_51605_) {
            final CompoundContainer $$2 = new CompoundContainer(p_51604_, p_51605_);
            return Optional.of(new MenuProvider(){

                @Override
                @Nullable
                public AbstractContainerMenu createMenu(int p_51622_, Inventory p_51623_, Player p_51624_) {
                    if (p_51604_.canOpen(p_51624_) && p_51605_.canOpen(p_51624_)) {
                        p_51604_.unpackLootTable(p_51623_.player);
                        p_51605_.unpackLootTable(p_51623_.player);
                        return ChestMenu.sixRows(p_51622_, p_51623_, $$2);
                    }
                    return null;
                }

                @Override
                public Component getDisplayName() {
                    if (p_51604_.hasCustomName()) {
                        return p_51604_.getDisplayName();
                    }
                    if (p_51605_.hasCustomName()) {
                        return p_51605_.getDisplayName();
                    }
                    return Component.translatable("container.chestDouble");
                }
            });
        }

        @Override
        public Optional<MenuProvider> acceptSingle(ChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        @Override
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }

        @Override
        public /* synthetic */ Object acceptNone() {
            return this.acceptNone();
        }
    };

    @Override
    public MapCodec<? extends ChestBlock> codec() {
        return CODEC;
    }

    protected ChestBlock(BlockBehaviour.Properties p_51490_, Supplier<BlockEntityType<? extends ChestBlockEntity>> p_51491_) {
        super(p_51490_, p_51491_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TYPE, ChestType.SINGLE)).setValue(WATERLOGGED, false));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState p_51583_) {
        ChestType $$1 = p_51583_.getValue(TYPE);
        if ($$1 == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        if ($$1 == ChestType.RIGHT) {
            return DoubleBlockCombiner.BlockType.FIRST;
        }
        return DoubleBlockCombiner.BlockType.SECOND;
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_51567_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected BlockState updateShape(BlockState p_51555_, Direction p_51556_, BlockState p_51557_, LevelAccessor p_51558_, BlockPos p_51559_, BlockPos p_51560_) {
        if (p_51555_.getValue(WATERLOGGED).booleanValue()) {
            p_51558_.scheduleTick(p_51559_, Fluids.WATER, Fluids.WATER.getTickDelay(p_51558_));
        }
        if (p_51557_.is(this) && p_51556_.getAxis().isHorizontal()) {
            ChestType $$6 = p_51557_.getValue(TYPE);
            if (p_51555_.getValue(TYPE) == ChestType.SINGLE && $$6 != ChestType.SINGLE && p_51555_.getValue(FACING) == p_51557_.getValue(FACING) && ChestBlock.getConnectedDirection(p_51557_) == p_51556_.getOpposite()) {
                return (BlockState)p_51555_.setValue(TYPE, $$6.getOpposite());
            }
        } else if (ChestBlock.getConnectedDirection(p_51555_) == p_51556_) {
            return (BlockState)p_51555_.setValue(TYPE, ChestType.SINGLE);
        }
        return super.updateShape(p_51555_, p_51556_, p_51557_, p_51558_, p_51559_, p_51560_);
    }

    @Override
    protected VoxelShape getShape(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        if (p_51569_.getValue(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        switch (ChestBlock.getConnectedDirection(p_51569_)) {
            default: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public static Direction getConnectedDirection(BlockState p_51585_) {
        Direction $$1 = p_51585_.getValue(FACING);
        return p_51585_.getValue(TYPE) == ChestType.LEFT ? $$1.getClockWise() : $$1.getCounterClockWise();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_51493_) {
        Direction $$6;
        ChestType $$1 = ChestType.SINGLE;
        Direction $$2 = p_51493_.getHorizontalDirection().getOpposite();
        FluidState $$3 = p_51493_.getLevel().getFluidState(p_51493_.getClickedPos());
        boolean $$4 = p_51493_.isSecondaryUseActive();
        Direction $$5 = p_51493_.getClickedFace();
        if ($$5.getAxis().isHorizontal() && $$4 && ($$6 = this.candidatePartnerFacing(p_51493_, $$5.getOpposite())) != null && $$6.getAxis() != $$5.getAxis()) {
            $$2 = $$6;
            ChestType chestType = $$1 = $$2.getCounterClockWise() == $$5.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if ($$1 == ChestType.SINGLE && !$$4) {
            if ($$2 == this.candidatePartnerFacing(p_51493_, $$2.getClockWise())) {
                $$1 = ChestType.LEFT;
            } else if ($$2 == this.candidatePartnerFacing(p_51493_, $$2.getCounterClockWise())) {
                $$1 = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, $$2)).setValue(TYPE, $$1)).setValue(WATERLOGGED, $$3.getType() == Fluids.WATER);
    }

    @Override
    protected FluidState getFluidState(BlockState p_51581_) {
        if (p_51581_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_51581_);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext p_51495_, Direction p_51496_) {
        BlockState $$2 = p_51495_.getLevel().getBlockState(p_51495_.getClickedPos().relative(p_51496_));
        return $$2.is(this) && $$2.getValue(TYPE) == ChestType.SINGLE ? $$2.getValue(FACING) : null;
    }

    @Override
    protected void onRemove(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        Containers.dropContentsOnDestroy(p_51538_, p_51541_, p_51539_, p_51540_);
        super.onRemove(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_51531_, Level p_51532_, BlockPos p_51533_, Player p_51534_, BlockHitResult p_51536_) {
        if (p_51532_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider $$5 = this.getMenuProvider(p_51531_, p_51532_, p_51533_);
        if ($$5 != null) {
            p_51534_.openMenu($$5);
            p_51534_.awardStat(this.getOpenChestStat());
            PiglinAi.angerNearbyPiglins(p_51534_, true);
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get(Stats.OPEN_CHEST);
    }

    public BlockEntityType<? extends ChestBlockEntity> blockEntityType() {
        return (BlockEntityType)this.blockEntityType.get();
    }

    @Nullable
    public static Container getContainer(ChestBlock p_51512_, BlockState p_51513_, Level p_51514_, BlockPos p_51515_, boolean p_51516_) {
        return p_51512_.combine(p_51513_, p_51514_, p_51515_, p_51516_).apply(CHEST_COMBINER).orElse(null);
    }

    @Override
    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> combine(BlockState p_51544_, Level p_51545_, BlockPos p_51546_, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> $$5;
        if (p_51547_) {
            BiPredicate<LevelAccessor, BlockPos> $$4 = (p_51578_, p_51579_) -> false;
        } else {
            $$5 = ChestBlock::isChestBlockedAt;
        }
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)this.blockEntityType.get(), ChestBlock::getBlockType, ChestBlock::getConnectedDirection, FACING, p_51544_, p_51545_, p_51546_, $$5);
    }

    @Override
    @Nullable
    protected MenuProvider getMenuProvider(BlockState p_51574_, Level p_51575_, BlockPos p_51576_) {
        return this.combine(p_51574_, p_51575_, p_51576_, false).apply(MENU_PROVIDER_COMBINER).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity p_51518_) {
        return new DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction acceptDouble(ChestBlockEntity p_51633_, ChestBlockEntity p_51634_) {
                return p_51638_ -> Math.max(p_51633_.getOpenNess(p_51638_), p_51634_.getOpenNess(p_51638_));
            }

            @Override
            public Float2FloatFunction acceptSingle(ChestBlockEntity p_51631_) {
                return p_51631_::getOpenNess;
            }

            @Override
            public Float2FloatFunction acceptNone() {
                return p_51518_::getOpenNess;
            }

            @Override
            public /* synthetic */ Object acceptNone() {
                return this.acceptNone();
            }
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_153064_, BlockState p_153065_) {
        return new ChestBlockEntity(p_153064_, p_153065_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153055_, BlockState p_153056_, BlockEntityType<T> p_153057_) {
        return p_153055_.isClientSide ? ChestBlock.createTickerHelper(p_153057_, this.blockEntityType(), ChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isChestBlockedAt(LevelAccessor p_51509_, BlockPos p_51510_) {
        return ChestBlock.isBlockedChestByBlock(p_51509_, p_51510_) || ChestBlock.isCatSittingOnChest(p_51509_, p_51510_);
    }

    private static boolean isBlockedChestByBlock(BlockGetter p_51500_, BlockPos p_51501_) {
        BlockPos $$2 = p_51501_.above();
        return p_51500_.getBlockState($$2).isRedstoneConductor(p_51500_, $$2);
    }

    private static boolean isCatSittingOnChest(LevelAccessor p_51564_, BlockPos p_51565_) {
        List<Cat> $$2 = p_51564_.getEntitiesOfClass(Cat.class, new AABB(p_51565_.getX(), p_51565_.getY() + 1, p_51565_.getZ(), p_51565_.getX() + 1, p_51565_.getY() + 2, p_51565_.getZ() + 1));
        if (!$$2.isEmpty()) {
            for (Cat $$3 : $$2) {
                if (!$$3.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_51520_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_51527_, Level p_51528_, BlockPos p_51529_) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer(ChestBlock.getContainer(this, p_51527_, p_51528_, p_51529_, false));
    }

    @Override
    protected BlockState rotate(BlockState p_51552_, Rotation p_51553_) {
        return (BlockState)p_51552_.setValue(FACING, p_51553_.rotate(p_51552_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_51549_, Mirror p_51550_) {
        return p_51549_.rotate(p_51550_.getRotation(p_51549_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_51562_) {
        p_51562_.add(FACING, TYPE, WATERLOGGED);
    }

    @Override
    protected boolean isPathfindable(BlockState p_51522_, PathComputationType p_51525_) {
        return false;
    }

    @Override
    protected void tick(BlockState p_220958_, ServerLevel p_220959_, BlockPos p_220960_, RandomSource p_220961_) {
        BlockEntity $$4 = p_220959_.getBlockEntity(p_220960_);
        if ($$4 instanceof ChestBlockEntity) {
            ((ChestBlockEntity)$$4).recheckOpen();
        }
    }
}

