/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StructurePlaceSettings {
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private BlockPos rotationPivot = BlockPos.ZERO;
    private boolean ignoreEntities;
    @Nullable
    private BoundingBox boundingBox;
    private LiquidSettings liquidSettings = LiquidSettings.APPLY_WATERLOGGING;
    @Nullable
    private RandomSource random;
    private int palette;
    private final List<StructureProcessor> processors = Lists.newArrayList();
    private boolean knownShape;
    private boolean finalizeEntities;

    public StructurePlaceSettings copy() {
        StructurePlaceSettings $$0 = new StructurePlaceSettings();
        $$0.mirror = this.mirror;
        $$0.rotation = this.rotation;
        $$0.rotationPivot = this.rotationPivot;
        $$0.ignoreEntities = this.ignoreEntities;
        $$0.boundingBox = this.boundingBox;
        $$0.liquidSettings = this.liquidSettings;
        $$0.random = this.random;
        $$0.palette = this.palette;
        $$0.processors.addAll(this.processors);
        $$0.knownShape = this.knownShape;
        $$0.finalizeEntities = this.finalizeEntities;
        return $$0;
    }

    public StructurePlaceSettings setMirror(Mirror p_74378_) {
        this.mirror = p_74378_;
        return this;
    }

    public StructurePlaceSettings setRotation(Rotation p_74380_) {
        this.rotation = p_74380_;
        return this;
    }

    public StructurePlaceSettings setRotationPivot(BlockPos p_74386_) {
        this.rotationPivot = p_74386_;
        return this;
    }

    public StructurePlaceSettings setIgnoreEntities(boolean p_74393_) {
        this.ignoreEntities = p_74393_;
        return this;
    }

    public StructurePlaceSettings setBoundingBox(BoundingBox p_74382_) {
        this.boundingBox = p_74382_;
        return this;
    }

    public StructurePlaceSettings setRandom(@Nullable RandomSource p_230325_) {
        this.random = p_230325_;
        return this;
    }

    public StructurePlaceSettings setLiquidSettings(LiquidSettings p_352241_) {
        this.liquidSettings = p_352241_;
        return this;
    }

    public StructurePlaceSettings setKnownShape(boolean p_74403_) {
        this.knownShape = p_74403_;
        return this;
    }

    public StructurePlaceSettings clearProcessors() {
        this.processors.clear();
        return this;
    }

    public StructurePlaceSettings addProcessor(StructureProcessor p_74384_) {
        this.processors.add(p_74384_);
        return this;
    }

    public StructurePlaceSettings popProcessor(StructureProcessor p_74398_) {
        this.processors.remove(p_74398_);
        return this;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public BlockPos getRotationPivot() {
        return this.rotationPivot;
    }

    public RandomSource getRandom(@Nullable BlockPos p_230327_) {
        if (this.random != null) {
            return this.random;
        }
        if (p_230327_ == null) {
            return RandomSource.create(Util.getMillis());
        }
        return RandomSource.create(Mth.getSeed(p_230327_));
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    @Nullable
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean getKnownShape() {
        return this.knownShape;
    }

    public List<StructureProcessor> getProcessors() {
        return this.processors;
    }

    public boolean shouldApplyWaterlogging() {
        return this.liquidSettings == LiquidSettings.APPLY_WATERLOGGING;
    }

    public StructureTemplate.Palette getRandomPalette(List<StructureTemplate.Palette> p_74388_, @Nullable BlockPos p_74389_) {
        int $$2 = p_74388_.size();
        if ($$2 == 0) {
            throw new IllegalStateException("No palettes");
        }
        return p_74388_.get(this.getRandom(p_74389_).nextInt($$2));
    }

    public StructurePlaceSettings setFinalizeEntities(boolean p_74406_) {
        this.finalizeEntities = p_74406_;
        return this;
    }

    public boolean shouldFinalizeEntities() {
        return this.finalizeEntities;
    }
}

