/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignedMessageValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInfo {
    private final GameProfile profile;
    private final java.util.function.Supplier<PlayerSkin> skinLookup;
    private GameType gameMode = GameType.DEFAULT_MODE;
    private int latency;
    @Nullable
    private Component tabListDisplayName;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageValidator messageValidator;

    public PlayerInfo(GameProfile p_253609_, boolean p_254409_) {
        this.profile = p_253609_;
        this.messageValidator = PlayerInfo.fallbackMessageValidator(p_254409_);
        Supplier supplier = Suppliers.memoize(() -> PlayerInfo.createSkinLookup(p_253609_));
        this.skinLookup = () -> PlayerInfo.lambda$new$1((java.util.function.Supplier)supplier);
    }

    private static java.util.function.Supplier<PlayerSkin> createSkinLookup(GameProfile p_298306_) {
        Minecraft minecraft = Minecraft.getInstance();
        SkinManager skinmanager = minecraft.getSkinManager();
        CompletableFuture completablefuture = skinmanager.getOrLoad(p_298306_);
        boolean flag = !minecraft.isLocalPlayer(p_298306_.getId());
        PlayerSkin playerskin = DefaultPlayerSkin.get((GameProfile)p_298306_);
        return () -> {
            PlayerSkin playerskin1 = completablefuture.getNow(playerskin);
            return flag && !playerskin1.secure() ? playerskin : playerskin1;
        };
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        return this.chatSession;
    }

    public SignedMessageValidator getMessageValidator() {
        return this.messageValidator;
    }

    public boolean hasVerifiableChat() {
        return this.chatSession != null;
    }

    protected void setChatSession(RemoteChatSession p_249599_) {
        this.chatSession = p_249599_;
        this.messageValidator = p_249599_.createMessageValidator(ProfilePublicKey.EXPIRY_GRACE_PERIOD);
    }

    protected void clearChatSession(boolean p_254536_) {
        this.chatSession = null;
        this.messageValidator = PlayerInfo.fallbackMessageValidator(p_254536_);
    }

    private static SignedMessageValidator fallbackMessageValidator(boolean p_254311_) {
        return p_254311_ ? SignedMessageValidator.REJECT_ALL : SignedMessageValidator.ACCEPT_UNSIGNED;
    }

    public GameType getGameMode() {
        return this.gameMode;
    }

    protected void setGameMode(GameType p_105318_) {
        ForgeHooksClient.onClientChangeGameType((PlayerInfo)this, (GameType)this.gameMode, (GameType)p_105318_);
        this.gameMode = p_105318_;
    }

    public int getLatency() {
        return this.latency;
    }

    protected void setLatency(int p_105314_) {
        this.latency = p_105314_;
    }

    public PlayerSkin getSkin() {
        return this.skinLookup.get();
    }

    @Nullable
    public PlayerTeam getTeam() {
        return Minecraft.getInstance().level.getScoreboard().getPlayersTeam(this.getProfile().getName());
    }

    public void setTabListDisplayName(@Nullable Component p_105324_) {
        this.tabListDisplayName = p_105324_;
    }

    @Nullable
    public Component getTabListDisplayName() {
        return this.tabListDisplayName;
    }

    private static /* synthetic */ PlayerSkin lambda$new$1(java.util.function.Supplier supplier) {
        return (PlayerSkin)((java.util.function.Supplier)supplier.get()).get();
    }
}

