/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Selector;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class MultiVariantGenerator
implements BlockStateGenerator {
    private final Block block;
    private final List<Variant> baseVariants;
    private final Set<Property<?>> seenProperties = Sets.newHashSet();
    private final List<PropertyDispatch> declaredPropertySets = Lists.newArrayList();

    private MultiVariantGenerator(Block $$0, List<Variant> $$1) {
        this.block = $$0;
        this.baseVariants = $$1;
    }

    public MultiVariantGenerator with(PropertyDispatch $$02) {
        $$02.getDefinedProperties().forEach($$0 -> {
            if (this.block.getStateDefinition().getProperty($$0.getName()) != $$0) {
                throw new IllegalStateException("Property " + String.valueOf($$0) + " is not defined for block " + String.valueOf(this.block));
            }
            if (!this.seenProperties.add((Property<?>)$$0)) {
                throw new IllegalStateException("Values of property " + String.valueOf($$0) + " already defined for block " + String.valueOf(this.block));
            }
        });
        this.declaredPropertySets.add($$02);
        return this;
    }

    @Override
    public JsonElement get() {
        Stream<Object> $$0 = Stream.of(Pair.of((Object)Selector.empty(), this.baseVariants));
        for (PropertyDispatch $$13 : this.declaredPropertySets) {
            Map<Selector, List<Variant>> $$2 = $$13.getEntries();
            $$0 = $$0.flatMap($$12 -> $$2.entrySet().stream().map($$1 -> {
                Selector $$2 = ((Selector)$$12.getFirst()).extend((Selector)$$1.getKey());
                List<Variant> $$3 = MultiVariantGenerator.mergeVariants((List)$$12.getSecond(), (List)$$1.getValue());
                return Pair.of((Object)$$2, $$3);
            }));
        }
        TreeMap $$3 = new TreeMap();
        $$0.forEach($$1 -> $$3.put(((Selector)$$1.getFirst()).getKey(), Variant.convertList((List)$$1.getSecond())));
        JsonObject $$4 = new JsonObject();
        $$4.add("variants", (JsonElement)Util.make(new JsonObject(), $$1 -> $$3.forEach((arg_0, arg_1) -> ((JsonObject)$$1).add(arg_0, arg_1))));
        return $$4;
    }

    private static List<Variant> mergeVariants(List<Variant> $$0, List<Variant> $$1) {
        ImmutableList.Builder $$2 = ImmutableList.builder();
        $$0.forEach($$22 -> $$1.forEach($$2 -> $$2.add((Object)Variant.merge($$22, $$2))));
        return $$2.build();
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public static MultiVariantGenerator multiVariant(Block $$0) {
        return new MultiVariantGenerator($$0, (List<Variant>)ImmutableList.of((Object)Variant.variant()));
    }

    public static MultiVariantGenerator multiVariant(Block $$0, Variant $$1) {
        return new MultiVariantGenerator($$0, (List<Variant>)ImmutableList.of((Object)$$1));
    }

    public static MultiVariantGenerator multiVariant(Block $$0, Variant ... $$1) {
        return new MultiVariantGenerator($$0, (List<Variant>)ImmutableList.copyOf((Object[])$$1));
    }

    @Override
    public /* synthetic */ Object get() {
        return this.get();
    }
}

