/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ServerboundPlaceRecipePacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundPlaceRecipePacket> STREAM_CODEC = Packet.codec(ServerboundPlaceRecipePacket::write, ServerboundPlaceRecipePacket::new);
    private final int containerId;
    private final ResourceLocation recipe;
    private final boolean shiftDown;

    public ServerboundPlaceRecipePacket(int $$0, RecipeHolder<?> $$1, boolean $$2) {
        this.containerId = $$0;
        this.recipe = $$1.id();
        this.shiftDown = $$2;
    }

    private ServerboundPlaceRecipePacket(FriendlyByteBuf $$0) {
        this.containerId = $$0.readByte();
        this.recipe = $$0.readResourceLocation();
        this.shiftDown = $$0.readBoolean();
    }

    private void write(FriendlyByteBuf $$0) {
        $$0.writeByte(this.containerId);
        $$0.writeResourceLocation(this.recipe);
        $$0.writeBoolean(this.shiftDown);
    }

    @Override
    public PacketType<ServerboundPlaceRecipePacket> type() {
        return GamePacketTypes.SERVERBOUND_PLACE_RECIPE;
    }

    @Override
    public void handle(ServerGamePacketListener $$0) {
        $$0.handlePlaceRecipe(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public ResourceLocation getRecipe() {
        return this.recipe;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }
}

