/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ContainerHelper {
    public static final String TAG_ITEMS = "Items";

    public static ItemStack removeItem(List<ItemStack> $$0, int $$1, int $$2) {
        if ($$1 < 0 || $$1 >= $$0.size() || $$0.get($$1).isEmpty() || $$2 <= 0) {
            return ItemStack.EMPTY;
        }
        return $$0.get($$1).split($$2);
    }

    public static ItemStack takeItem(List<ItemStack> $$0, int $$1) {
        if ($$1 < 0 || $$1 >= $$0.size()) {
            return ItemStack.EMPTY;
        }
        return $$0.set($$1, ItemStack.EMPTY);
    }

    public static CompoundTag saveAllItems(CompoundTag $$0, NonNullList<ItemStack> $$1, HolderLookup.Provider $$2) {
        return ContainerHelper.saveAllItems($$0, $$1, true, $$2);
    }

    public static CompoundTag saveAllItems(CompoundTag $$0, NonNullList<ItemStack> $$1, boolean $$2, HolderLookup.Provider $$3) {
        ListTag $$4 = new ListTag();
        for (int $$5 = 0; $$5 < $$1.size(); ++$$5) {
            ItemStack $$6 = $$1.get($$5);
            if ($$6.isEmpty()) continue;
            CompoundTag $$7 = new CompoundTag();
            $$7.putByte("Slot", (byte)$$5);
            $$4.add($$6.save($$3, $$7));
        }
        if (!$$4.isEmpty() || $$2) {
            $$0.put(TAG_ITEMS, $$4);
        }
        return $$0;
    }

    public static void loadAllItems(CompoundTag $$0, NonNullList<ItemStack> $$1, HolderLookup.Provider $$2) {
        ListTag $$3 = $$0.getList(TAG_ITEMS, 10);
        for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
            CompoundTag $$5 = $$3.getCompound($$4);
            int $$6 = $$5.getByte("Slot") & 0xFF;
            if ($$6 < 0 || $$6 >= $$1.size()) continue;
            $$1.set($$6, ItemStack.parse($$2, $$5).orElse(ItemStack.EMPTY));
        }
    }

    public static int clearOrCountMatchingItems(Container $$0, Predicate<ItemStack> $$1, int $$2, boolean $$3) {
        int $$4 = 0;
        for (int $$5 = 0; $$5 < $$0.getContainerSize(); ++$$5) {
            ItemStack $$6 = $$0.getItem($$5);
            int $$7 = ContainerHelper.clearOrCountMatchingItems($$6, $$1, $$2 - $$4, $$3);
            if ($$7 > 0 && !$$3 && $$6.isEmpty()) {
                $$0.setItem($$5, ItemStack.EMPTY);
            }
            $$4 += $$7;
        }
        return $$4;
    }

    public static int clearOrCountMatchingItems(ItemStack $$0, Predicate<ItemStack> $$1, int $$2, boolean $$3) {
        if ($$0.isEmpty() || !$$1.test($$0)) {
            return 0;
        }
        if ($$3) {
            return $$0.getCount();
        }
        int $$4 = $$2 < 0 ? $$0.getCount() : Math.min($$2, $$0.getCount());
        $$0.shrink($$4);
        return $$4;
    }
}

