/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeInstance {
    private static final String BASE_FIELD = "base";
    private static final String MODIFIERS_FIELD = "modifiers";
    public static final String ID_FIELD = "id";
    private final Holder<Attribute> attribute;
    private final Map<AttributeModifier.Operation, Map<ResourceLocation, AttributeModifier>> modifiersByOperation = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<ResourceLocation, AttributeModifier> modifierById = new Object2ObjectArrayMap();
    private final Map<ResourceLocation, AttributeModifier> permanentModifiers = new Object2ObjectArrayMap();
    private double baseValue;
    private boolean dirty = true;
    private double cachedValue;
    private final Consumer<AttributeInstance> onDirty;

    public AttributeInstance(Holder<Attribute> $$0, Consumer<AttributeInstance> $$1) {
        this.attribute = $$0;
        this.onDirty = $$1;
        this.baseValue = $$0.value().getDefaultValue();
    }

    public Holder<Attribute> getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double $$0) {
        if ($$0 == this.baseValue) {
            return;
        }
        this.baseValue = $$0;
        this.setDirty();
    }

    @VisibleForTesting
    Map<ResourceLocation, AttributeModifier> getModifiers(AttributeModifier.Operation $$02) {
        return this.modifiersByOperation.computeIfAbsent($$02, $$0 -> new Object2ObjectOpenHashMap());
    }

    public Set<AttributeModifier> getModifiers() {
        return ImmutableSet.copyOf(this.modifierById.values());
    }

    @Nullable
    public AttributeModifier getModifier(ResourceLocation $$0) {
        return this.modifierById.get($$0);
    }

    public boolean hasModifier(ResourceLocation $$0) {
        return this.modifierById.get($$0) != null;
    }

    private void addModifier(AttributeModifier $$0) {
        AttributeModifier $$1 = this.modifierById.putIfAbsent($$0.id(), $$0);
        if ($$1 != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.getModifiers($$0.operation()).put($$0.id(), $$0);
        this.setDirty();
    }

    public void addOrUpdateTransientModifier(AttributeModifier $$0) {
        AttributeModifier $$1 = this.modifierById.put($$0.id(), $$0);
        if ($$0 == $$1) {
            return;
        }
        this.getModifiers($$0.operation()).put($$0.id(), $$0);
        this.setDirty();
    }

    public void addTransientModifier(AttributeModifier $$0) {
        this.addModifier($$0);
    }

    public void addOrReplacePermanentModifier(AttributeModifier $$0) {
        this.removeModifier($$0.id());
        this.addModifier($$0);
        this.permanentModifiers.put($$0.id(), $$0);
    }

    public void addPermanentModifier(AttributeModifier $$0) {
        this.addModifier($$0);
        this.permanentModifiers.put($$0.id(), $$0);
    }

    protected void setDirty() {
        this.dirty = true;
        this.onDirty.accept(this);
    }

    public void removeModifier(AttributeModifier $$0) {
        this.removeModifier($$0.id());
    }

    public boolean removeModifier(ResourceLocation $$0) {
        AttributeModifier $$1 = this.modifierById.remove($$0);
        if ($$1 == null) {
            return false;
        }
        this.getModifiers($$1.operation()).remove($$0);
        this.permanentModifiers.remove($$0);
        this.setDirty();
        return true;
    }

    public void removeModifiers() {
        for (AttributeModifier $$0 : this.getModifiers()) {
            this.removeModifier($$0);
        }
    }

    public double getValue() {
        if (this.dirty) {
            this.cachedValue = this.calculateValue();
            this.dirty = false;
        }
        return this.cachedValue;
    }

    private double calculateValue() {
        double $$0 = this.getBaseValue();
        for (AttributeModifier $$1 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_VALUE)) {
            $$0 += $$1.amount();
        }
        double $$2 = $$0;
        for (AttributeModifier $$3 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
            $$2 += $$0 * $$3.amount();
        }
        for (AttributeModifier $$4 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
            $$2 *= 1.0 + $$4.amount();
        }
        return this.attribute.value().sanitizeValue($$2);
    }

    private Collection<AttributeModifier> getModifiersOrEmpty(AttributeModifier.Operation $$0) {
        return this.modifiersByOperation.getOrDefault($$0, Map.of()).values();
    }

    public void replaceFrom(AttributeInstance $$02) {
        this.baseValue = $$02.baseValue;
        this.modifierById.clear();
        this.modifierById.putAll($$02.modifierById);
        this.permanentModifiers.clear();
        this.permanentModifiers.putAll($$02.permanentModifiers);
        this.modifiersByOperation.clear();
        $$02.modifiersByOperation.forEach(($$0, $$1) -> this.getModifiers((AttributeModifier.Operation)$$0).putAll((Map<ResourceLocation, AttributeModifier>)$$1));
        this.setDirty();
    }

    public CompoundTag save() {
        CompoundTag $$0 = new CompoundTag();
        ResourceKey<Attribute> $$1 = this.attribute.unwrapKey().orElseThrow(() -> new IllegalStateException("Tried to serialize unregistered attribute"));
        $$0.putString(ID_FIELD, $$1.location().toString());
        $$0.putDouble(BASE_FIELD, this.baseValue);
        if (!this.permanentModifiers.isEmpty()) {
            ListTag $$2 = new ListTag();
            for (AttributeModifier $$3 : this.permanentModifiers.values()) {
                $$2.add($$3.save());
            }
            $$0.put(MODIFIERS_FIELD, $$2);
        }
        return $$0;
    }

    public void load(CompoundTag $$0) {
        this.baseValue = $$0.getDouble(BASE_FIELD);
        if ($$0.contains(MODIFIERS_FIELD, 9)) {
            ListTag $$1 = $$0.getList(MODIFIERS_FIELD, 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                AttributeModifier $$3 = AttributeModifier.load($$1.getCompound($$2));
                if ($$3 == null) continue;
                this.modifierById.put($$3.id(), $$3);
                this.getModifiers($$3.operation()).put($$3.id(), $$3);
                this.permanentModifiers.put($$3.id(), $$3);
            }
        }
        this.setDirty();
    }
}

