/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class OminousBottleItem
extends Item {
    private static final int DRINK_DURATION = 32;
    public static final int EFFECT_DURATION = 120000;
    public static final int MIN_AMPLIFIER = 0;
    public static final int MAX_AMPLIFIER = 4;

    public OminousBottleItem(Item.Properties $$0) {
        super($$0);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack $$0, Level $$1, LivingEntity $$2) {
        if ($$2 instanceof ServerPlayer) {
            ServerPlayer $$3 = (ServerPlayer)$$2;
            CriteriaTriggers.CONSUME_ITEM.trigger($$3, $$0);
            $$3.awardStat(Stats.ITEM_USED.get(this));
        }
        if (!$$1.isClientSide) {
            $$1.playSound(null, $$2.blockPosition(), SoundEvents.OMINOUS_BOTTLE_DISPOSE, $$2.getSoundSource(), 1.0f, 1.0f);
            Integer $$4 = (Integer)$$0.getOrDefault(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, 0);
            $$2.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 120000, $$4, false, false, true));
        }
        $$0.consume(1, $$2);
        return $$0;
    }

    @Override
    public int getUseDuration(ItemStack $$0, LivingEntity $$1) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack $$0) {
        return UseAnim.DRINK;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        return ItemUtils.startUsingInstantly($$0, $$1, $$2);
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        super.appendHoverText($$0, $$1, $$2, $$3);
        Integer $$4 = (Integer)$$0.getOrDefault(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, 0);
        List<MobEffectInstance> $$5 = List.of(new MobEffectInstance(MobEffects.BAD_OMEN, 120000, $$4, false, false, true));
        PotionContents.addPotionTooltip($$5, $$2::add, 1.0f, $$1.tickRate());
    }
}

