/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PotionItem
extends Item {
    private static final int DRINK_DURATION = 32;

    public PotionItem(Item.Properties $$0) {
        super($$0);
    }

    @Override
    public ItemStack getDefaultInstance() {
        ItemStack $$0 = super.getDefaultInstance();
        $$0.set(DataComponents.POTION_CONTENTS, new PotionContents(Potions.WATER));
        return $$0;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack $$0, Level $$1, LivingEntity $$22) {
        Player $$3;
        Player player = $$3 = $$22 instanceof Player ? (Player)$$22 : null;
        if ($$3 instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)$$3, $$0);
        }
        if (!$$1.isClientSide) {
            PotionContents $$4 = (PotionContents)$$0.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            $$4.forEachEffect($$2 -> {
                if ($$2.getEffect().value().isInstantenous()) {
                    $$2.getEffect().value().applyInstantenousEffect($$3, $$3, $$22, $$2.getAmplifier(), 1.0);
                } else {
                    $$22.addEffect((MobEffectInstance)$$2);
                }
            });
        }
        if ($$3 != null) {
            $$3.awardStat(Stats.ITEM_USED.get(this));
            $$0.consume(1, $$3);
        }
        if ($$3 == null || !$$3.hasInfiniteMaterials()) {
            if ($$0.isEmpty()) {
                return new ItemStack(Items.GLASS_BOTTLE);
            }
            if ($$3 != null) {
                $$3.getInventory().add(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        $$22.gameEvent(GameEvent.DRINK);
        return $$0;
    }

    @Override
    public InteractionResult useOn(UseOnContext $$0) {
        Level $$1 = $$0.getLevel();
        BlockPos $$2 = $$0.getClickedPos();
        Player $$3 = $$0.getPlayer();
        ItemStack $$4 = $$0.getItemInHand();
        PotionContents $$5 = (PotionContents)$$4.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        BlockState $$6 = $$1.getBlockState($$2);
        if ($$0.getClickedFace() != Direction.DOWN && $$6.is(BlockTags.CONVERTABLE_TO_MUD) && $$5.is(Potions.WATER)) {
            $$1.playSound(null, $$2, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
            $$3.setItemInHand($$0.getHand(), ItemUtils.createFilledResult($$4, $$3, new ItemStack(Items.GLASS_BOTTLE)));
            $$3.awardStat(Stats.ITEM_USED.get($$4.getItem()));
            if (!$$1.isClientSide) {
                ServerLevel $$7 = (ServerLevel)$$1;
                for (int $$8 = 0; $$8 < 5; ++$$8) {
                    $$7.sendParticles(ParticleTypes.SPLASH, (double)$$2.getX() + $$1.random.nextDouble(), $$2.getY() + 1, (double)$$2.getZ() + $$1.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            $$1.playSound(null, $$2, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            $$1.gameEvent(null, GameEvent.FLUID_PLACE, $$2);
            $$1.setBlockAndUpdate($$2, Blocks.MUD.defaultBlockState());
            return InteractionResult.sidedSuccess($$1.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack $$0, LivingEntity $$1) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack $$0) {
        return UseAnim.DRINK;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        return ItemUtils.startUsingInstantly($$0, $$1, $$2);
    }

    @Override
    public String getDescriptionId(ItemStack $$0) {
        return Potion.getName(((PotionContents)$$0.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY)).potion(), this.getDescriptionId() + ".effect.");
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        PotionContents $$4 = (PotionContents)$$0.get(DataComponents.POTION_CONTENTS);
        if ($$4 == null) {
            return;
        }
        $$4.addPotionTooltip($$2::add, 1.0f, $$1.tickRate());
    }
}

