/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents EMPTY = new BundleContents(List.of());
    public static final Codec<BundleContents> CODEC = ItemStack.CODEC.listOf().xmap(BundleContents::new, $$0 -> $$0.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BundleContents::new, $$0 -> $$0.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    private static final int NO_STACK_INDEX = -1;
    final List<ItemStack> items;
    final Fraction weight;

    BundleContents(List<ItemStack> $$0, Fraction $$1) {
        this.items = $$0;
        this.weight = $$1;
    }

    public BundleContents(List<ItemStack> $$0) {
        this($$0, BundleContents.computeContentWeight($$0));
    }

    private static Fraction computeContentWeight(List<ItemStack> $$0) {
        Fraction $$1 = Fraction.ZERO;
        for (ItemStack $$2 : $$0) {
            $$1 = $$1.add(BundleContents.getWeight($$2).multiplyBy(Fraction.getFraction((int)$$2.getCount(), (int)1)));
        }
        return $$1;
    }

    static Fraction getWeight(ItemStack $$0) {
        BundleContents $$1 = (BundleContents)$$0.get(DataComponents.BUNDLE_CONTENTS);
        if ($$1 != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add($$1.weight());
        }
        List $$2 = (List)$$0.getOrDefault(DataComponents.BEES, List.of());
        if (!$$2.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)$$0.getMaxStackSize());
    }

    public ItemStack getItemUnsafe(int $$0) {
        return this.items.get($$0);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if ($$0 instanceof BundleContents) {
            BundleContents $$1 = (BundleContents)$$0;
            return this.weight.equals((Object)$$1.weight) && ItemStack.listMatches(this.items, $$1.items);
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "BundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;

        public Mutable(BundleContents $$0) {
            this.items = new ArrayList<ItemStack>($$0.items);
            this.weight = $$0.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack $$0) {
            if (!$$0.isStackable()) {
                return -1;
            }
            for (int $$1 = 0; $$1 < this.items.size(); ++$$1) {
                if (!ItemStack.isSameItemSameComponents(this.items.get($$1), $$0)) continue;
                return $$1;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack $$0) {
            Fraction $$1 = Fraction.ONE.subtract(this.weight);
            return Math.max($$1.divideBy(BundleContents.getWeight($$0)).intValue(), 0);
        }

        public int tryInsert(ItemStack $$0) {
            if ($$0.isEmpty() || !$$0.getItem().canFitInsideContainerItems()) {
                return 0;
            }
            int $$1 = Math.min($$0.getCount(), this.getMaxAmountToAdd($$0));
            if ($$1 == 0) {
                return 0;
            }
            this.weight = this.weight.add(BundleContents.getWeight($$0).multiplyBy(Fraction.getFraction((int)$$1, (int)1)));
            int $$2 = this.findStackIndex($$0);
            if ($$2 != -1) {
                ItemStack $$3 = this.items.remove($$2);
                ItemStack $$4 = $$3.copyWithCount($$3.getCount() + $$1);
                $$0.shrink($$1);
                this.items.add(0, $$4);
            } else {
                this.items.add(0, $$0.split($$1));
            }
            return $$1;
        }

        public int tryTransfer(Slot $$0, Player $$1) {
            ItemStack $$2 = $$0.getItem();
            int $$3 = this.getMaxAmountToAdd($$2);
            return this.tryInsert($$0.safeTake($$2.getCount(), $$3, $$1));
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack $$0 = this.items.remove(0).copy();
            this.weight = this.weight.subtract(BundleContents.getWeight($$0).multiplyBy(Fraction.getFraction((int)$$0.getCount(), (int)1)));
            return $$0;
        }

        public Fraction weight() {
            return this.weight;
        }

        public BundleContents toImmutable() {
            return new BundleContents(List.copyOf(this.items), this.weight);
        }
    }
}

