/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record ItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of(), true);
    private static final Codec<ItemAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(ItemAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(ItemAttributeModifiers::showInTooltip)).apply((Applicative)$$0, ItemAttributeModifiers::new));
    public static final Codec<ItemAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), $$0 -> new ItemAttributeModifiers((List<Entry>)$$0, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ByteBufCodecs.BOOL, ItemAttributeModifiers::showInTooltip, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = Util.make(new DecimalFormat("#.##"), $$0 -> $$0.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public ItemAttributeModifiers withTooltip(boolean $$0) {
        return new ItemAttributeModifiers(this.modifiers, $$0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2) {
        ImmutableList.Builder $$3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry $$4 : this.modifiers) {
            if ($$4.matches($$0, $$1.id())) continue;
            $$3.add((Object)$$4);
        }
        $$3.add((Object)new Entry($$0, $$1, $$2));
        return new ItemAttributeModifiers((List<Entry>)$$3.build(), this.showInTooltip);
    }

    public void forEach(EquipmentSlotGroup $$0, BiConsumer<Holder<Attribute>, AttributeModifier> $$1) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.equals($$0)) continue;
            $$1.accept($$2.attribute, $$2.modifier);
        }
    }

    public void forEach(EquipmentSlot $$0, BiConsumer<Holder<Attribute>, AttributeModifier> $$1) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.test($$0)) continue;
            $$1.accept($$2.attribute, $$2.modifier);
        }
    }

    public double compute(double $$0, EquipmentSlot $$1) {
        double $$2 = $$0;
        for (Entry $$3 : this.modifiers) {
            if (!$$3.slot.test($$1)) continue;
            double $$4 = $$3.modifier.amount();
            $$2 += (switch ($$3.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> $$4;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> $$4 * $$0;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> $$4 * $$2;
            });
        }
        return $$2;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2) {
            this.entries.add((Object)new Entry($$0, $$1, $$2));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot)).apply((Applicative)$$0, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(Attribute.STREAM_CODEC, Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Entry::new);

        public boolean matches(Holder<Attribute> $$0, ResourceLocation $$1) {
            return $$0.equals(this.attribute) && this.modifier.is($$1);
        }
    }
}

