/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import org.slf4j.Logger;

public class MobSpawnSettings {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float DEFAULT_CREATURE_SPAWN_PROBABILITY = 0.1f;
    public static final WeightedRandomList<SpawnerData> EMPTY_MOB_LIST = WeightedRandomList.create();
    public static final MobSpawnSettings EMPTY = new Builder().build();
    public static final MapCodec<MobSpawnSettings> CODEC = RecordCodecBuilder.mapCodec(p_187051_ -> p_187051_.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(p_187055_ -> Float.valueOf(p_187055_.creatureGenerationProbability)), (App)Codec.simpleMap(MobCategory.CODEC, (Codec)WeightedRandomList.codec(SpawnerData.CODEC).promotePartial(Util.prefix("Spawn data: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)StringRepresentable.keys(MobCategory.values())).fieldOf("spawners").forGetter(p_187053_ -> p_187053_.spawners), (App)Codec.simpleMap(BuiltInRegistries.ENTITY_TYPE.byNameCodec(), MobSpawnCost.CODEC, BuiltInRegistries.ENTITY_TYPE).fieldOf("spawn_costs").forGetter(p_187049_ -> p_187049_.mobSpawnCosts)).apply((Applicative)p_187051_, MobSpawnSettings::new));
    private final float creatureGenerationProbability;
    private final Map<MobCategory, WeightedRandomList<SpawnerData>> spawners;
    private final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts;
    private final Set<MobCategory> typesView;
    private final Set<EntityType<?>> costView;

    MobSpawnSettings(float p_196689_, Map<MobCategory, WeightedRandomList<SpawnerData>> p_196690_, Map<EntityType<?>, MobSpawnCost> p_196691_) {
        this.creatureGenerationProbability = p_196689_;
        this.spawners = ImmutableMap.copyOf(p_196690_);
        this.mobSpawnCosts = ImmutableMap.copyOf(p_196691_);
        this.typesView = Collections.unmodifiableSet(this.spawners.keySet());
        this.costView = Collections.unmodifiableSet(this.mobSpawnCosts.keySet());
    }

    public WeightedRandomList<SpawnerData> getMobs(MobCategory p_151799_) {
        return this.spawners.getOrDefault(p_151799_, EMPTY_MOB_LIST);
    }

    @Nullable
    public MobSpawnCost getMobSpawnCost(EntityType<?> p_48346_) {
        return this.mobSpawnCosts.get(p_48346_);
    }

    public float getCreatureProbability() {
        return this.creatureGenerationProbability;
    }

    public Set<MobCategory> getSpawnerTypes() {
        return this.typesView;
    }

    public Set<EntityType<?>> getEntityTypes() {
        return this.costView;
    }

    public record MobSpawnCost(double energyBudget, double charge) {
        public static final Codec<MobSpawnCost> CODEC = RecordCodecBuilder.create(p_48399_ -> p_48399_.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(p_151813_ -> p_151813_.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(p_151811_ -> p_151811_.charge)).apply((Applicative)p_48399_, MobSpawnCost::new));
    }

    public static class SpawnerData
    extends WeightedEntry.IntrusiveBase {
        public static final Codec<SpawnerData> CODEC = RecordCodecBuilder.create(p_341821_ -> p_341821_.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(p_151826_ -> p_151826_.type), (App)Weight.CODEC.fieldOf("weight").forGetter(WeightedEntry.IntrusiveBase::getWeight), (App)ExtraCodecs.POSITIVE_INT.fieldOf("minCount").forGetter(p_151824_ -> p_151824_.minCount), (App)ExtraCodecs.POSITIVE_INT.fieldOf("maxCount").forGetter(p_151820_ -> p_151820_.maxCount)).apply((Applicative)p_341821_, SpawnerData::new)).validate(p_275168_ -> p_275168_.minCount > p_275168_.maxCount ? DataResult.error(() -> "minCount needs to be smaller or equal to maxCount") : DataResult.success((Object)p_275168_));
        public final EntityType<?> type;
        public final int minCount;
        public final int maxCount;

        public SpawnerData(EntityType<?> p_48409_, int p_48410_, int p_48411_, int p_48412_) {
            this(p_48409_, Weight.of(p_48410_), p_48411_, p_48412_);
        }

        public SpawnerData(EntityType<?> p_151815_, Weight p_151816_, int p_151817_, int p_151818_) {
            super(p_151816_);
            this.type = p_151815_.getCategory() == MobCategory.MISC ? EntityType.PIG : p_151815_;
            this.minCount = p_151817_;
            this.maxCount = p_151818_;
        }

        public String toString() {
            return String.valueOf(EntityType.getKey(this.type)) + "*(" + this.minCount + "-" + this.maxCount + "):" + String.valueOf(this.getWeight());
        }
    }

    public static class Builder {
        protected final Map<MobCategory, List<SpawnerData>> spawners = (Map)Stream.of(MobCategory.values()).collect(ImmutableMap.toImmutableMap(p_48383_ -> p_48383_, p_48375_ -> Lists.newArrayList()));
        protected final Map<EntityType<?>, MobSpawnCost> mobSpawnCosts = Maps.newLinkedHashMap();
        protected float creatureGenerationProbability = 0.1f;

        public Builder addSpawn(MobCategory p_48377_, SpawnerData p_48378_) {
            this.spawners.get(p_48377_).add(p_48378_);
            return this;
        }

        public Builder addMobCharge(EntityType<?> p_48371_, double p_48372_, double p_48373_) {
            this.mobSpawnCosts.put(p_48371_, new MobSpawnCost(p_48373_, p_48372_));
            return this;
        }

        public Builder creatureGenerationProbability(float p_48369_) {
            this.creatureGenerationProbability = p_48369_;
            return this;
        }

        public MobSpawnSettings build() {
            return new MobSpawnSettings(this.creatureGenerationProbability, (Map)this.spawners.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_151809_ -> WeightedRandomList.create((List)p_151809_.getValue()))), (Map<EntityType<?>, MobSpawnCost>)ImmutableMap.copyOf(this.mobSpawnCosts));
        }
    }
}

