/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class NetherPortalBlock
extends Block
implements Portal {
    public static final MapCodec<NetherPortalBlock> CODEC = NetherPortalBlock.simpleCodec(NetherPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public MapCodec<NetherPortalBlock> codec() {
        return CODEC;
    }

    public NetherPortalBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, Direction.Axis.X));
    }

    @Override
    protected VoxelShape getShape(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        switch ($$0.getValue(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    @Override
    protected void randomTick(BlockState $$0, ServerLevel $$1, BlockPos $$2, RandomSource $$3) {
        if ($$1.dimensionType().natural() && $$1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && $$3.nextInt(2000) < $$1.getDifficulty().getId()) {
            ZombifiedPiglin $$4;
            while ($$1.getBlockState($$2).is(this)) {
                $$2 = $$2.below();
            }
            if ($$1.getBlockState($$2).isValidSpawn($$1, $$2, EntityType.ZOMBIFIED_PIGLIN) && ($$4 = EntityType.ZOMBIFIED_PIGLIN.spawn($$1, $$2.above(), MobSpawnType.STRUCTURE)) != null) {
                $$4.setPortalCooldown();
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState $$0, Direction $$1, BlockState $$2, LevelAccessor $$3, BlockPos $$4, BlockPos $$5) {
        boolean $$8;
        Direction.Axis $$6 = $$1.getAxis();
        Direction.Axis $$7 = $$0.getValue(AXIS);
        boolean bl = $$8 = $$7 != $$6 && $$6.isHorizontal();
        if ($$8 || $$2.is(this) || new PortalShape($$3, $$4, $$7).isComplete()) {
            return super.updateShape($$0, $$1, $$2, $$3, $$4, $$5);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected void entityInside(BlockState $$0, Level $$1, BlockPos $$2, Entity $$3) {
        if ($$3.canUsePortal(false)) {
            $$3.setAsInsidePortal(this, $$2);
        }
    }

    @Override
    public int getPortalTransitionTime(ServerLevel $$0, Entity $$1) {
        if ($$1 instanceof Player) {
            Player $$2 = (Player)$$1;
            return Math.max(1, $$0.getGameRules().getInt($$2.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    @Override
    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel $$0, Entity $$1, BlockPos $$2) {
        ResourceKey<Level> $$3 = $$0.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER;
        ServerLevel $$4 = $$0.getServer().getLevel($$3);
        if ($$4 == null) {
            return null;
        }
        boolean $$5 = $$4.dimension() == Level.NETHER;
        WorldBorder $$6 = $$4.getWorldBorder();
        double $$7 = DimensionType.getTeleportationScale($$0.dimensionType(), $$4.dimensionType());
        BlockPos $$8 = $$6.clampToBounds($$1.getX() * $$7, $$1.getY(), $$1.getZ() * $$7);
        return this.getExitPortal($$4, $$1, $$2, $$8, $$5, $$6);
    }

    @Nullable
    private DimensionTransition getExitPortal(ServerLevel $$0, Entity $$12, BlockPos $$22, BlockPos $$3, boolean $$4, WorldBorder $$5) {
        DimensionTransition.PostDimensionTransition $$14;
        BlockUtil.FoundRectangle $$13;
        Optional<BlockPos> $$6 = $$0.getPortalForcer().findClosestPortalPosition($$3, $$4, $$5);
        if ($$6.isPresent()) {
            BlockPos $$7 = $$6.get();
            BlockState $$8 = $$0.getBlockState($$7);
            BlockUtil.FoundRectangle $$9 = BlockUtil.getLargestRectangleAround($$7, $$8.getValue(BlockStateProperties.HORIZONTAL_AXIS), 21, Direction.Axis.Y, 21, $$2 -> $$0.getBlockState((BlockPos)$$2) == $$8);
            DimensionTransition.PostDimensionTransition $$10 = DimensionTransition.PLAY_PORTAL_SOUND.then($$1 -> $$1.placePortalTicket($$7));
        } else {
            Direction.Axis $$11 = $$12.level().getBlockState($$22).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> $$122 = $$0.getPortalForcer().createPortal($$3, $$11);
            if ($$122.isEmpty()) {
                LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            $$13 = $$122.get();
            $$14 = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return NetherPortalBlock.getDimensionTransitionFromExit($$12, $$22, $$13, $$0, $$14);
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity $$0, BlockPos $$1, BlockUtil.FoundRectangle $$22, ServerLevel $$3, DimensionTransition.PostDimensionTransition $$4) {
        Vec3 $$10;
        Direction.Axis $$9;
        BlockState $$5 = $$0.level().getBlockState($$1);
        if ($$5.hasProperty(BlockStateProperties.HORIZONTAL_AXIS)) {
            Direction.Axis $$6 = $$5.getValue(BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle $$7 = BlockUtil.getLargestRectangleAround($$1, $$6, 21, Direction.Axis.Y, 21, $$2 -> $$0.level().getBlockState((BlockPos)$$2) == $$5);
            Vec3 $$8 = $$0.getRelativePortalPosition($$6, $$7);
        } else {
            $$9 = Direction.Axis.X;
            $$10 = new Vec3(0.5, 0.0, 0.0);
        }
        return NetherPortalBlock.createDimensionTransition($$3, $$22, $$9, $$10, $$0, $$0.getDeltaMovement(), $$0.getYRot(), $$0.getXRot(), $$4);
    }

    private static DimensionTransition createDimensionTransition(ServerLevel $$0, BlockUtil.FoundRectangle $$1, Direction.Axis $$2, Vec3 $$3, Entity $$4, Vec3 $$5, float $$6, float $$7, DimensionTransition.PostDimensionTransition $$8) {
        BlockPos $$9 = $$1.minCorner;
        BlockState $$10 = $$0.getBlockState($$9);
        Direction.Axis $$11 = $$10.getOptionalValue(BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double $$12 = $$1.axis1Size;
        double $$13 = $$1.axis2Size;
        EntityDimensions $$14 = $$4.getDimensions($$4.getPose());
        int $$15 = $$2 == $$11 ? 0 : 90;
        Vec3 $$16 = $$2 == $$11 ? $$5 : new Vec3($$5.z, $$5.y, -$$5.x);
        double $$17 = (double)$$14.width() / 2.0 + ($$12 - (double)$$14.width()) * $$3.x();
        double $$18 = ($$13 - (double)$$14.height()) * $$3.y();
        double $$19 = 0.5 + $$3.z();
        boolean $$20 = $$11 == Direction.Axis.X;
        Vec3 $$21 = new Vec3((double)$$9.getX() + ($$20 ? $$17 : $$19), (double)$$9.getY() + $$18, (double)$$9.getZ() + ($$20 ? $$19 : $$17));
        Vec3 $$22 = PortalShape.findCollisionFreePosition($$21, $$0, $$4, $$14);
        return new DimensionTransition($$0, $$22, $$16, $$6 + (float)$$15, $$7, $$8);
    }

    @Override
    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    @Override
    public void animateTick(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        if ($$3.nextInt(100) == 0) {
            $$1.playLocalSound((double)$$2.getX() + 0.5, (double)$$2.getY() + 0.5, (double)$$2.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, $$3.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            double $$5 = (double)$$2.getX() + $$3.nextDouble();
            double $$6 = (double)$$2.getY() + $$3.nextDouble();
            double $$7 = (double)$$2.getZ() + $$3.nextDouble();
            double $$8 = ((double)$$3.nextFloat() - 0.5) * 0.5;
            double $$9 = ((double)$$3.nextFloat() - 0.5) * 0.5;
            double $$10 = ((double)$$3.nextFloat() - 0.5) * 0.5;
            int $$11 = $$3.nextInt(2) * 2 - 1;
            if ($$1.getBlockState($$2.west()).is(this) || $$1.getBlockState($$2.east()).is(this)) {
                $$7 = (double)$$2.getZ() + 0.5 + 0.25 * (double)$$11;
                $$10 = $$3.nextFloat() * 2.0f * (float)$$11;
            } else {
                $$5 = (double)$$2.getX() + 0.5 + 0.25 * (double)$$11;
                $$8 = $$3.nextFloat() * 2.0f * (float)$$11;
            }
            $$1.addParticle(ParticleTypes.PORTAL, $$5, $$6, $$7, $$8, $$9, $$10);
        }
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader $$0, BlockPos $$1, BlockState $$2) {
        return ItemStack.EMPTY;
    }

    @Override
    protected BlockState rotate(BlockState $$0, Rotation $$1) {
        switch ($$1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ($$0.getValue(AXIS)) {
                    case X: {
                        return (BlockState)$$0.setValue(AXIS, Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)$$0.setValue(AXIS, Direction.Axis.X);
                    }
                }
                return $$0;
            }
        }
        return $$0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(AXIS);
    }
}

