/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class StrictNBTIngredient
extends AbstractIngredient {
    private final ItemStack stack;
    public static final MapCodec<StrictNBTIngredient> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(i -> i.stack)).apply((Applicative)b, StrictNBTIngredient::new));
    public static final IIngredientSerializer<StrictNBTIngredient> SERIALIZER = new IIngredientSerializer<StrictNBTIngredient>(){

        @Override
        public MapCodec<? extends StrictNBTIngredient> codec() {
            return CODEC;
        }

        @Override
        public void write(RegistryFriendlyByteBuf buffer, StrictNBTIngredient value) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)value.stack);
        }

        @Override
        public StrictNBTIngredient read(RegistryFriendlyByteBuf buffer) {
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new StrictNBTIngredient(stack);
        }
    };

    public static StrictNBTIngredient of(ItemStack stack) {
        return new StrictNBTIngredient(stack);
    }

    private StrictNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CustomData inbt = (CustomData)input.get(DataComponents.CUSTOM_DATA);
        CustomData tnbt = (CustomData)this.stack.get(DataComponents.CUSTOM_DATA);
        if (inbt == null || tnbt == null) {
            return false;
        }
        return this.stack.getItem() == input.getItem() && tnbt.matchedBy(inbt.copyTag());
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

