/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.nio.pathfs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraftforge.jarjar.nio.pathfs.PathFSUtils;
import net.minecraftforge.jarjar.nio.pathfs.PathFileSystemProvider;
import net.minecraftforge.jarjar.nio.pathfs.PathPath;
import net.minecraftforge.jarjar.nio.util.LambdaExceptionUtils;
import net.minecraftforge.jarjar.nio.util.Lazy;

public class PathFileSystem
extends FileSystem {
    private final Path root = new PathPath(this, false, "/").toAbsolutePath();
    private final PathFileSystemProvider provider;
    private final String key;
    private final Path target;
    private final Lazy<FileSystem> innerSystem;
    private final Lazy<Path> innerFSTarget;

    PathFileSystem(PathFileSystemProvider provider, String key, Path target) {
        this.provider = provider;
        this.key = key;
        this.target = target;
        this.innerSystem = Lazy.of(() -> {
            try {
                return FileSystems.newFileSystem(target, this.getClass().getClassLoader());
            }
            catch (IOException e) {
                return (FileSystem)PathFileSystem.sneak(e);
            }
        });
        this.innerFSTarget = this.innerSystem.map(fileSystem -> {
            if (fileSystem == target.getFileSystem()) {
                return target;
            }
            ArrayList roots = new ArrayList();
            fileSystem.getRootDirectories().forEach(roots::add);
            if (roots.size() != 1) {
                throw new UnsupportedOperationException("Invalid PathFileSystem, Multiple roots: " + target.toUri());
            }
            return (Path)roots.get(0);
        });
    }

    public String getKey() {
        return this.key;
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public PathFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
        this.innerSystem.ifPresent(LambdaExceptionUtils.uncheckConsume(FileSystem::close));
        this.provider().removeFileSystem(this);
    }

    @Override
    public boolean isOpen() {
        return this.innerSystem.map(FileSystem::isOpen).orElse(true);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (path.toAbsolutePath().equals(this.root)) {
            return Files.readAttributes(this.target, type, options);
        }
        return this.innerSystem.get().provider().readAttributes(this.getOuterTarget(path), type, options);
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singletonList(this.root);
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.singleton("basic");
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (path.toAbsolutePath().equals(this.root)) {
            try {
                return Files.newByteChannel(this.target, options, attrs);
            }
            catch (UncheckedIOException ioe) {
                throw ioe.getCause();
            }
        }
        return this.innerSystem.get().provider().newByteChannel(this.getOuterTarget(path), options, attrs);
    }

    private Path getOuterTarget(Path path) {
        if (path.isAbsolute()) {
            path = this.root.relativize(path);
        }
        Path innerRoot = this.innerFSTarget.get();
        return innerRoot.resolve(path.toString());
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length > 0) {
            String[] args = new String[more.length + 1];
            args[0] = first;
            System.arraycopy(more, 0, args, 1, more.length);
            return this.provider().createSubPath(this, args);
        }
        return this.provider().createSubPath(this, first);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
        if (dir.toAbsolutePath().equals(this.root)) {
            try {
                return PathFSUtils.adapt(Files.newDirectoryStream(this.innerFSTarget.get(), filter), path -> new PathPath(this, this.innerFSTarget.get().relativize((Path)path)));
            }
            catch (IOException e) {
                return PathFSUtils.NULL_STREAM;
            }
        }
        try {
            return PathFSUtils.adapt(this.innerSystem.get().provider().newDirectoryStream(this.getOuterTarget(dir), filter), path -> new PathPath(this, this.target.relativize((Path)path)));
        }
        catch (IOException e) {
            return PathFSUtils.NULL_STREAM;
        }
    }

    public Path getTarget() {
        return this.target;
    }

    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.innerSystem.get().provider().checkAccess(this.getOuterTarget(path), modes);
    }

    private static <E extends Throwable, R> R sneak(Exception exception) throws E {
        throw exception;
    }
}

