/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class ModContainer {
    protected final String modId;
    protected final String namespace;
    protected final IModInfo modInfo;
    protected ModLoadingStage modLoadingStage;
    protected Supplier<?> contextExtension;
    protected final Map<ModLoadingStage, Runnable> activityMap = new EnumMap<ModLoadingStage, Runnable>(ModLoadingStage.class);
    protected final Map<Class<? extends IExtensionPoint<?>>, Supplier<?>> extensionPoints = new IdentityHashMap();
    protected final EnumMap<ModConfig.Type, ModConfig> configs = new EnumMap(ModConfig.Type.class);
    protected Optional<Consumer<IConfigEvent>> configHandler = Optional.empty();

    public ModContainer(IModInfo info) {
        String displayTestString;
        this.namespace = this.modId = info.getModId();
        this.modInfo = info;
        this.modLoadingStage = ModLoadingStage.CONSTRUCT;
        Supplier<IExtensionPoint.DisplayTest> displayTestSupplier = switch (displayTestString = info.getConfig().getConfigElement("displayTest").orElseGet(() -> info.getOwningFile().isClientSideOnly() ? "IGNORE_ALL_VERSION" : "MATCH_VERSION")) {
            case "MATCH_VERSION" -> () -> new IExtensionPoint.DisplayTest(() -> this.modInfo.getVersion().toString(), (incoming, isNetwork) -> Objects.equals(incoming, this.modInfo.getVersion().toString()));
            case "IGNORE_SERVER_VERSION" -> IExtensionPoint.DisplayTest.IGNORE_SERVER_VERSION;
            case "IGNORE_ALL_VERSION" -> IExtensionPoint.DisplayTest.IGNORE_ALL_VERSION;
            case "NONE" -> null;
            default -> throw new IllegalArgumentException("Invalid displayTest value supplied in mods.toml");
        };
        if (displayTestSupplier != null) {
            this.registerExtensionPoint(IExtensionPoint.DisplayTest.class, displayTestSupplier);
        } else {
            this.extensionPoints.remove(IExtensionPoint.DisplayTest.class);
        }
    }

    ModContainer() {
        this.modLoadingStage = ModLoadingStage.ERROR;
        this.modId = "BROKEN";
        this.namespace = "BROKEN";
        this.modInfo = null;
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public ModLoadingStage getCurrentState() {
        return this.modLoadingStage;
    }

    public static <T extends Event> CompletableFuture<Void> buildTransitionHandler(ModContainer target, IModStateTransition.EventGenerator<T> eventGenerator, ProgressMeter progressBar, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChangeHandler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ModLoadingContext.get().setActiveContainer(target);
            target.activityMap.getOrDefault((Object)target.modLoadingStage, () -> {}).run();
            target.acceptEvent((Event)eventGenerator.apply(target));
        }, executor).whenComplete((mc, exception) -> {
            target.modLoadingStage = (ModLoadingStage)((Object)((Object)stateChangeHandler.apply(target.modLoadingStage, (Throwable)exception)));
            progressBar.increment();
            ModLoadingContext.get().setActiveContainer(null);
        });
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public <T extends Record> Optional<T> getCustomExtension(Class<? extends IExtensionPoint<T>> point) {
        return Optional.ofNullable((Record)this.extensionPoints.getOrDefault(point, () -> null).get());
    }

    public <T extends Record> void registerExtensionPoint(Class<? extends IExtensionPoint<T>> point, Supplier<T> extension) {
        this.extensionPoints.put(point, extension);
    }

    public void registerDisplayTest(IExtensionPoint.DisplayTest displayTest) {
        this.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> displayTest);
    }

    public void registerDisplayTest(Supplier<IExtensionPoint.DisplayTest> displayTest) {
        this.registerExtensionPoint(IExtensionPoint.DisplayTest.class, displayTest);
    }

    public void registerDisplayTest(String version, BiPredicate<String, Boolean> remoteVersionTest) {
        this.registerDisplayTest(new IExtensionPoint.DisplayTest(version, remoteVersionTest));
    }

    public void registerDisplayTest(Supplier<String> suppliedVersion, BiPredicate<String, Boolean> remoteVersionTest) {
        this.registerDisplayTest(new IExtensionPoint.DisplayTest(suppliedVersion, remoteVersionTest));
    }

    public void addConfig(ModConfig modConfig) {
        this.configs.put(modConfig.getType(), modConfig);
    }

    public void dispatchConfigEvent(IConfigEvent event) {
        Consumer handler = this.configHandler.orElse(null);
        if (handler != null) {
            handler.accept(event);
        }
    }

    public abstract boolean matches(Object var1);

    public abstract Object getMod();

    protected <T extends Event> void acceptEvent(T e) {
    }
}

