/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.CoreModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModFileParser {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static IModFileInfo readModList(ModFile modFile, ModFileFactory.ModFileInfoParser parser) {
        return parser.build((IModFile)modFile);
    }

    @Nullable
    public static IModFileInfo modsTomlParser(IModFile imodFile) {
        ModFile modFile = (ModFile)imodFile;
        LOGGER.debug(LogMarkers.LOADING, "Considering mod file candidate {}", (Object)modFile.getFilePath());
        Path modsjson = modFile.findResource("META-INF", "mods.toml");
        if (!Files.exists(modsjson, new LinkOption[0])) {
            LOGGER.warn(LogMarkers.LOADING, "Mod file {} is missing mods.toml file", (Object)modFile.getFilePath());
            return null;
        }
        FileConfig fileConfig = FileConfig.builder((Path)modsjson).build();
        fileConfig.load();
        fileConfig.close();
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)fileConfig);
        return new ModFileInfo(modFile, configWrapper, configWrapper::setFile);
    }

    protected static List<CoreModFile> getCoreMods(ModFile modFile) {
        Map coreModPaths;
        try {
            Path coremodsjson = modFile.findResource("META-INF", "coremods.json");
            if (!Files.exists(coremodsjson, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson gson = new Gson();
            coreModPaths = (Map)gson.fromJson((Reader)Files.newBufferedReader(coremodsjson), type);
        }
        catch (IOException e2) {
            LOGGER.debug(LogMarkers.LOADING, "Failed to read coremod list coremods.json", (Throwable)e2);
            return Collections.emptyList();
        }
        return coreModPaths.entrySet().stream().peek(e -> LOGGER.debug(LogMarkers.LOADING, "Found coremod {} with Javascript path {}", e.getKey(), e.getValue())).map(e -> new CoreModFile((String)e.getKey(), modFile.findResource((String)e.getValue()), modFile)).toList();
    }
}

