/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.VersionSupportMatrix;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class ModSorter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final UniqueModListBuilder uniqueModListBuilder;
    private List<ModFile> modFiles;
    private List<ModInfo> sortedList;
    private Map<String, IModInfo> modIdNameLookup;
    private List<ModFile> systemMods;

    private ModSorter(List<ModFile> modFiles) {
        this.uniqueModListBuilder = new UniqueModListBuilder(modFiles);
    }

    public static LoadingModList sort(List<ModFile> mods, List<EarlyLoadingException.ExceptionData> errors) {
        ModSorter ms = new ModSorter(mods);
        try {
            ms.buildUniqueList();
        }
        catch (EarlyLoadingException e) {
            return LoadingModList.of(ms.systemMods, ms.systemMods.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).toList(), e);
        }
        List<EarlyLoadingException.ExceptionData> failedList = Stream.concat(ms.verifyDependencyVersions().stream(), errors.stream()).toList();
        if (!failedList.isEmpty()) {
            return LoadingModList.of(ms.systemMods, ms.systemMods.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).toList(), new EarlyLoadingException("failure to validate mod list", null, failedList));
        }
        EarlyLoadingException earlyLoadingException = null;
        try {
            ms.sort();
        }
        catch (EarlyLoadingException e) {
            earlyLoadingException = e;
        }
        return LoadingModList.of(ms.modFiles, ms.sortedList, earlyLoadingException);
    }

    private void sort() {
        List<ModFileInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        AtomicInteger counter = new AtomicInteger();
        Map infos = this.modFiles.stream().map(ModFile::getModFileInfo).filter(ModFileInfo.class::isInstance).map(ModFileInfo.class::cast).collect(Collectors.toMap(Function.identity(), e -> counter.incrementAndGet()));
        infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(IModInfo::getDependencies).flatMap(Collection::stream).forEach(dep -> this.addDependency((MutableGraph<ModFileInfo>)graph, (IModInfo.ModVersion)dep));
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e2) {
            Set cycles = e2.getCycles();
            if (LOGGER.isErrorEnabled(LogMarkers.LOADING)) {
                LOGGER.error(LogMarkers.LOADING, "Mod Sorting failed.\nDetected Cycles: {}\n", cycles);
            }
            List<EarlyLoadingException.ExceptionData> dataList = cycles.stream().flatMap(Collection::stream).mapMulti((mf, c) -> mf.getMods().forEach(c)).map(IModInfo::getModId).map(list -> new EarlyLoadingException.ExceptionData("fml.modloading.cycle", list)).toList();
            throw new EarlyLoadingException("Sorting error", e2, dataList);
        }
        this.sortedList = sorted.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toList());
        this.modFiles = sorted.stream().map(ModFileInfo::getFile).collect(Collectors.toList());
    }

    private void addDependency(MutableGraph<ModFileInfo> topoGraph, IModInfo.ModVersion dep) {
        IModFileInfo iModFileInfo;
        IModInfo targetModInfo = this.modIdNameLookup.get(dep.getModId());
        if (targetModInfo == null || !((iModFileInfo = targetModInfo.getOwningFile()) instanceof ModFileInfo)) {
            return;
        }
        ModFileInfo target = (ModFileInfo)iModFileInfo;
        ModFileInfo self = (ModFileInfo)dep.getOwner().getOwningFile();
        if (self == target) {
            return;
        }
        switch (dep.getOrdering()) {
            case BEFORE: {
                topoGraph.putEdge((Object)self, (Object)target);
                break;
            }
            case AFTER: {
                topoGraph.putEdge((Object)target, (Object)self);
                break;
            }
        }
    }

    private void buildUniqueList() {
        UniqueModListBuilder.UniqueModListData uniqueModListData = this.uniqueModListBuilder.buildUniqueList();
        this.modFiles = uniqueModListData.modFiles();
        this.detectSystemMods(uniqueModListData.modFilesByFirstId());
        this.modIdNameLookup = uniqueModListData.modFilesByFirstId().entrySet().stream().filter(e -> !((ModFile)((List)e.getValue()).get(0)).getModInfos().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ModFile)((List)e.getValue()).get(0)).getModInfos().get(0)));
    }

    private void detectSystemMods(Map<String, List<ModFile>> modFilesByFirstId) {
        List<String> systemMods = List.of("minecraft", "forge");
        LOGGER.debug("Configured system mods: {}", systemMods);
        this.systemMods = new ArrayList<ModFile>();
        for (String systemMod : systemMods) {
            List<ModFile> container = modFilesByFirstId.get(systemMod);
            if (container != null && !container.isEmpty()) {
                LOGGER.debug("Found system mod: {}", (Object)systemMod);
                this.systemMods.add(container.getFirst());
                continue;
            }
            throw new IllegalStateException("Failed to find system mod: " + systemMod);
        }
    }

    private List<EarlyLoadingException.ExceptionData> verifyDependencyVersions() {
        Map<String, ArtifactVersion> modVersions = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.toMap(IModInfo::getModId, IModInfo::getVersion));
        Map modVersionDependencies = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.flatMapping(e -> e.getDependencies().stream(), Collectors.toList())));
        Set modRequirements = modVersionDependencies.values().stream().flatMap(Collection::stream).filter(mv -> mv.getSide().isCorrectSide()).collect(Collectors.toSet());
        long mandatoryRequired = modRequirements.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements ({} mandatory, {} optional)", new Object[]{modRequirements.size(), mandatoryRequired, (long)modRequirements.size() - mandatoryRequired});
        Set missingVersions = modRequirements.stream().filter(mv -> (mv.isMandatory() || modVersions.containsKey(mv.getModId())) && !ModSorter.modVersionContained(mv, modVersions)).collect(Collectors.toSet());
        long mandatoryMissing = missingVersions.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements missing ({} mandatory, {} optional)", new Object[]{missingVersions.size(), mandatoryMissing, (long)missingVersions.size() - mandatoryMissing});
        if (!missingVersions.isEmpty()) {
            if (mandatoryMissing > 0L) {
                LOGGER.error(LogMarkers.LOADING, "Missing or unsupported mandatory dependencies:\n{}", (Object)missingVersions.stream().filter(IModInfo.ModVersion::isMandatory).map(ver -> ModSorter.formatDependencyError(ver, modVersions)).collect(Collectors.joining("\n")));
            }
            if ((long)missingVersions.size() - mandatoryMissing > 0L) {
                LOGGER.error(LogMarkers.LOADING, "Unsupported installed optional dependencies:\n{}", (Object)missingVersions.stream().filter(ver -> !ver.isMandatory()).map(ver -> ModSorter.formatDependencyError(ver, modVersions)).collect(Collectors.joining("\n")));
            }
            return missingVersions.stream().map(mv -> new EarlyLoadingException.ExceptionData(mv.isMandatory() ? "fml.modloading.missingdependency" : "fml.modloading.missingdependency.optional", mv.getOwner(), new Object[]{mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), modVersions.getOrDefault(mv.getModId(), (ArtifactVersion)new DefaultArtifactVersion("null"))})).toList();
        }
        return Collections.emptyList();
    }

    private static String formatDependencyError(IModInfo.ModVersion dependency, Map<String, ArtifactVersion> modVersions) {
        ArtifactVersion installed = modVersions.get(dependency.getModId());
        return String.format("\tMod ID: '%s', Requested by: '%s', Expected range: '%s', Actual version: '%s'", dependency.getModId(), dependency.getOwner().getModId(), dependency.getVersionRange(), installed != null ? installed.toString() : "[MISSING]");
    }

    private static boolean modVersionContained(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions) {
        String modId = mv.getModId();
        VersionRange range = mv.getVersionRange();
        if (modVersions.containsKey(modId) && (range.containsVersion(modVersions.get(modId)) || modVersions.get(modId).toString().equals("0.0NONE"))) {
            return true;
        }
        return VersionSupportMatrix.testVersionSupportMatrix(mv.getVersionRange(), mv.getModId(), "mod");
    }
}

