/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.lang.module.ModuleDescriptor;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModJarMetadata
implements JarMetadata {
    private static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    private IModFile modFile;
    private String name;
    private String version;
    private ModuleDescriptor descriptor;

    ModJarMetadata() {
    }

    public void setModFile(IModFile file) {
        SecureJar jar;
        String aname;
        this.modFile = file;
        List mods = this.modFile.getModFileInfo().getMods();
        if (!mods.isEmpty()) {
            IModInfo main = (IModInfo)mods.get(0);
            this.name = main.getModId();
            this.version = main.getVersion().toString();
        }
        if ((aname = (jar = file.getSecureJar()).moduleDataProvider().getManifest().getMainAttributes().getValue(AUTOMATIC_MODULE_NAME)) != null) {
            this.name = aname;
        }
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public ModuleDescriptor descriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name()).version(this.version()).packages(this.modFile.getSecureJar().getPackages());
        for (SecureJar.Provider provider : this.modFile.getSecureJar().getProviders()) {
            if (provider.providers().isEmpty()) continue;
            bld.provides(provider.serviceName(), provider.providers());
        }
        this.descriptor = bld.build();
        return this.descriptor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)obj;
        return Objects.equals(this.modFile, that.modFile);
    }

    public int hashCode() {
        return Objects.hash(this.modFile);
    }

    public String toString() {
        return "ModJarMetadata[modFile=" + String.valueOf(this.modFile) + "]";
    }
}

