/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.Difficulty;

public class ClientboundChangeDifficultyPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundChangeDifficultyPacket> STREAM_CODEC = Packet.codec(ClientboundChangeDifficultyPacket::write, ClientboundChangeDifficultyPacket::new);
    private final Difficulty difficulty;
    private final boolean locked;

    public ClientboundChangeDifficultyPacket(Difficulty $$0, boolean $$1) {
        this.difficulty = $$0;
        this.locked = $$1;
    }

    private ClientboundChangeDifficultyPacket(FriendlyByteBuf $$0) {
        this.difficulty = Difficulty.byId($$0.readUnsignedByte());
        this.locked = $$0.readBoolean();
    }

    private void write(FriendlyByteBuf $$0) {
        $$0.writeByte(this.difficulty.getId());
        $$0.writeBoolean(this.locked);
    }

    @Override
    public PacketType<ClientboundChangeDifficultyPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CHANGE_DIFFICULTY;
    }

    @Override
    public void handle(ClientGamePacketListener $$0) {
        $$0.handleChangeDifficulty(this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }
}

