/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.item.ItemStack;

public class ClientboundContainerSetContentPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundContainerSetContentPacket> STREAM_CODEC = Packet.codec(ClientboundContainerSetContentPacket::write, ClientboundContainerSetContentPacket::new);
    private final int containerId;
    private final int stateId;
    private final List<ItemStack> items;
    private final ItemStack carriedItem;

    public ClientboundContainerSetContentPacket(int $$0, int $$1, NonNullList<ItemStack> $$2, ItemStack $$3) {
        this.containerId = $$0;
        this.stateId = $$1;
        this.items = NonNullList.withSize($$2.size(), ItemStack.EMPTY);
        for (int $$4 = 0; $$4 < $$2.size(); ++$$4) {
            this.items.set($$4, $$2.get($$4).copy());
        }
        this.carriedItem = $$3.copy();
    }

    private ClientboundContainerSetContentPacket(RegistryFriendlyByteBuf $$0) {
        this.containerId = $$0.readUnsignedByte();
        this.stateId = $$0.readVarInt();
        this.items = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode($$0);
        this.carriedItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode($$0);
    }

    private void write(RegistryFriendlyByteBuf $$0) {
        $$0.writeByte(this.containerId);
        $$0.writeVarInt(this.stateId);
        ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode($$0, this.items);
        ItemStack.OPTIONAL_STREAM_CODEC.encode($$0, this.carriedItem);
    }

    @Override
    public PacketType<ClientboundContainerSetContentPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CONTAINER_SET_CONTENT;
    }

    @Override
    public void handle(ClientGamePacketListener $$0) {
        $$0.handleContainerContent(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getCarriedItem() {
        return this.carriedItem;
    }

    public int getStateId() {
        return this.stateId;
    }
}

