/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundPlayerInputPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundPlayerInputPacket> STREAM_CODEC = Packet.codec(ServerboundPlayerInputPacket::write, ServerboundPlayerInputPacket::new);
    private static final int FLAG_JUMPING = 1;
    private static final int FLAG_SHIFT_KEY_DOWN = 2;
    private final float xxa;
    private final float zza;
    private final boolean isJumping;
    private final boolean isShiftKeyDown;

    public ServerboundPlayerInputPacket(float $$0, float $$1, boolean $$2, boolean $$3) {
        this.xxa = $$0;
        this.zza = $$1;
        this.isJumping = $$2;
        this.isShiftKeyDown = $$3;
    }

    private ServerboundPlayerInputPacket(FriendlyByteBuf $$0) {
        this.xxa = $$0.readFloat();
        this.zza = $$0.readFloat();
        byte $$1 = $$0.readByte();
        this.isJumping = ($$1 & 1) > 0;
        this.isShiftKeyDown = ($$1 & 2) > 0;
    }

    private void write(FriendlyByteBuf $$0) {
        $$0.writeFloat(this.xxa);
        $$0.writeFloat(this.zza);
        byte $$1 = 0;
        if (this.isJumping) {
            $$1 = (byte)($$1 | 1);
        }
        if (this.isShiftKeyDown) {
            $$1 = (byte)($$1 | 2);
        }
        $$0.writeByte($$1);
    }

    @Override
    public PacketType<ServerboundPlayerInputPacket> type() {
        return GamePacketTypes.SERVERBOUND_PLAYER_INPUT;
    }

    @Override
    public void handle(ServerGamePacketListener $$0) {
        $$0.handlePlayerInput(this);
    }

    public float getXxa() {
        return this.xxa;
    }

    public float getZza() {
        return this.zza;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public boolean isShiftKeyDown() {
        return this.isShiftKeyDown;
    }
}

