/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<LayeredRegistryAccess<RegistryLayer>> reload(LayeredRegistryAccess<RegistryLayer> $$0, ResourceManager $$12, Executor $$2) {
        RegistryAccess.Frozen $$32 = $$0.getAccessForLoading(RegistryLayer.RELOADABLE);
        RegistryOps $$4 = new EmptyTagLookupWrapper($$32).createSerializationContext(JsonOps.INSTANCE);
        List<CompletableFuture> $$5 = LootDataType.values().map($$3 -> ReloadableServerRegistries.scheduleElementParse($$3, $$4, $$12, $$2)).toList();
        CompletableFuture $$6 = Util.sequence($$5);
        return $$6.thenApplyAsync($$1 -> ReloadableServerRegistries.apply($$0, $$1), $$2);
    }

    private static <T> CompletableFuture<WritableRegistry<?>> scheduleElementParse(LootDataType<T> $$0, RegistryOps<JsonElement> $$1, ResourceManager $$2, Executor $$3) {
        return CompletableFuture.supplyAsync(() -> {
            MappedRegistry $$3 = new MappedRegistry($$0.registryKey(), Lifecycle.experimental());
            HashMap<ResourceLocation, JsonElement> $$42 = new HashMap<ResourceLocation, JsonElement>();
            String $$5 = Registries.elementsDirPath($$0.registryKey());
            SimpleJsonResourceReloadListener.scanDirectory($$2, $$5, GSON, $$42);
            $$42.forEach(($$32, $$4) -> $$0.deserialize((ResourceLocation)$$32, $$1, $$4).ifPresent($$3 -> $$3.register(ResourceKey.create($$0.registryKey(), $$32), $$3, DEFAULT_REGISTRATION_INFO)));
            return $$3;
        }, $$3);
    }

    private static LayeredRegistryAccess<RegistryLayer> apply(LayeredRegistryAccess<RegistryLayer> $$02, List<WritableRegistry<?>> $$12) {
        LayeredRegistryAccess<RegistryLayer> $$22 = ReloadableServerRegistries.createUpdatedRegistries($$02, $$12);
        ProblemReporter.Collector $$3 = new ProblemReporter.Collector();
        RegistryAccess.Frozen $$4 = $$22.compositeAccess();
        ValidationContext $$5 = new ValidationContext($$3, LootContextParamSets.ALL_PARAMS, $$4.asGetterLookup());
        LootDataType.values().forEach($$2 -> ReloadableServerRegistries.validateRegistry($$5, $$2, $$4));
        $$3.get().forEach(($$0, $$1) -> LOGGER.warn("Found loot table element validation problem in {}: {}", $$0, $$1));
        return $$22;
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> $$0, List<WritableRegistry<?>> $$1) {
        RegistryAccess.ImmutableRegistryAccess $$2 = new RegistryAccess.ImmutableRegistryAccess($$1);
        ((WritableRegistry)$$2.registryOrThrow(Registries.LOOT_TABLE)).register(BuiltInLootTables.EMPTY, LootTable.EMPTY, DEFAULT_REGISTRATION_INFO);
        return $$0.replaceFrom(RegistryLayer.RELOADABLE, $$2.freeze());
    }

    private static <T> void validateRegistry(ValidationContext $$0, LootDataType<T> $$1, RegistryAccess $$22) {
        Registry<T> $$3 = $$22.registryOrThrow($$1.registryKey());
        $$3.holders().forEach($$2 -> $$1.runValidation($$0, $$2.key(), $$2.value()));
    }

    static class EmptyTagLookupWrapper
    implements HolderLookup.Provider {
        private final RegistryAccess registryAccess;

        EmptyTagLookupWrapper(RegistryAccess $$0) {
            this.registryAccess = $$0;
        }

        @Override
        public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
            return this.registryAccess.listRegistries();
        }

        @Override
        public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> $$0) {
            return this.registryAccess.registry($$0).map(Registry::asTagAddingLookup);
        }
    }

    public static class Holder {
        private final RegistryAccess.Frozen registries;

        public Holder(RegistryAccess.Frozen $$0) {
            this.registries = $$0;
        }

        public RegistryAccess.Frozen get() {
            return this.registries;
        }

        public HolderGetter.Provider lookup() {
            return this.registries.asGetterLookup();
        }

        public Collection<ResourceLocation> getKeys(ResourceKey<? extends Registry<?>> $$0) {
            return this.registries.registry($$0).stream().flatMap($$02 -> $$02.holders().map($$0 -> $$0.key().location())).toList();
        }

        public LootTable getLootTable(ResourceKey<LootTable> $$0) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap($$1 -> $$1.get($$0)).map(net.minecraft.core.Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

