/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ProcessorMailbox;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_KEPT_PACKS = 20;
    private final Path cacheDir;
    private final JsonEventLog<LogEntry> eventLog;
    private final ProcessorMailbox<Runnable> tasks = ProcessorMailbox.create(Util.nonCriticalIoPool(), "download-queue");

    public DownloadQueue(Path $$0) throws IOException {
        this.cacheDir = $$0;
        FileUtil.createDirectoriesSafe($$0);
        this.eventLog = JsonEventLog.open(LogEntry.CODEC, $$0.resolve("log.json"));
        DownloadCacheCleaner.vacuumCacheDir($$0, 20);
    }

    private BatchResult runDownload(BatchConfig $$0, Map<UUID, DownloadRequest> $$1) {
        BatchResult $$22 = new BatchResult();
        $$1.forEach(($$2, $$3) -> {
            Path $$4 = this.cacheDir.resolve($$2.toString());
            Path $$5 = null;
            try {
                $$5 = HttpUtil.downloadFile($$4, $$3.url, $$0.headers, $$0.hashFunction, $$3.hash, $$0.maxSize, $$0.proxy, $$0.listener);
                $$1.downloaded.put((UUID)$$2, $$5);
            }
            catch (Exception $$6) {
                LOGGER.error("Failed to download {}", (Object)$$3.url, (Object)$$6);
                $$1.failed.add((UUID)$$2);
            }
            try {
                this.eventLog.write(new LogEntry((UUID)$$2, $$3.url.toString(), Instant.now(), Optional.ofNullable($$3.hash).map(HashCode::toString), $$5 != null ? this.getFileInfo($$5) : Either.left((Object)"download_failed")));
            }
            catch (Exception $$7) {
                LOGGER.error("Failed to log download of {}", (Object)$$3.url, (Object)$$7);
            }
        });
        return $$22;
    }

    private Either<String, FileInfoEntry> getFileInfo(Path $$0) {
        try {
            long $$1 = Files.size($$0);
            Path $$2 = this.cacheDir.relativize($$0);
            return Either.right((Object)new FileInfoEntry($$2.toString(), $$1));
        }
        catch (IOException $$3) {
            LOGGER.error("Failed to get file size of {}", (Object)$$0, (Object)$$3);
            return Either.left((Object)"no_access");
        }
    }

    public CompletableFuture<BatchResult> downloadBatch(BatchConfig $$0, Map<UUID, DownloadRequest> $$1) {
        return CompletableFuture.supplyAsync(() -> this.runDownload($$0, $$1), this.tasks::tell);
    }

    @Override
    public void close() throws IOException {
        this.tasks.close();
        this.eventLog.close();
    }

    record LogEntry(UUID id, String url, Instant time, Optional<String> hash, Either<String, FileInfoEntry> errorOrFileInfo) {
        public static final Codec<LogEntry> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(LogEntry::id), (App)Codec.STRING.fieldOf("url").forGetter(LogEntry::url), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("time").forGetter(LogEntry::time), (App)Codec.STRING.optionalFieldOf("hash").forGetter(LogEntry::hash), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)FileInfoEntry.CODEC.fieldOf("file")).forGetter(LogEntry::errorOrFileInfo)).apply((Applicative)$$0, LogEntry::new));
    }

    public record BatchResult(Map<UUID, Path> downloaded, Set<UUID> failed) {
        public BatchResult() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }
    }

    public record BatchConfig(HashFunction hashFunction, int maxSize, Map<String, String> headers, Proxy proxy, HttpUtil.DownloadProgressListener listener) {
    }

    record FileInfoEntry(String name, long size) {
        public static final Codec<FileInfoEntry> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.STRING.fieldOf("name").forGetter(FileInfoEntry::name), (App)Codec.LONG.fieldOf("size").forGetter(FileInfoEntry::size)).apply((Applicative)$$0, FileInfoEntry::new));
    }

    public record DownloadRequest(URL url, @Nullable HashCode hash) {
    }
}

