/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final Function<ResourceLocation, Optional<? extends T>> idToValue;
    private final String directory;

    public TagLoader(Function<ResourceLocation, Optional<? extends T>> p_144493_, String p_144494_) {
        this.idToValue = p_144493_;
        this.directory = p_144494_;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager p_144496_) {
        HashMap map = Maps.newHashMap();
        FileToIdConverter filetoidconverter = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> entry : filetoidconverter.listMatchingResourceStacks(p_144496_).entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.fileToId(resourcelocation);
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourcelocation1, p_215974_ -> new ArrayList());
                        TagFile tagfile = (TagFile)TagFile.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement)).getOrThrow();
                        if (tagfile.replace()) {
                            list.clear();
                        }
                        String s = resource.sourcePackId();
                        tagfile.entries().forEach(p_215997_ -> list.add(new EntryWithSource((TagEntry)p_215997_, s)));
                        tagfile.remove().forEach(e -> list.add(new EntryWithSource((TagEntry)e, s, true)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourcelocation1, resourcelocation, resource.sourcePackId(), exception});
                }
            }
        }
        return map;
    }

    private Either<Collection<EntryWithSource>, Collection<T>> build(TagEntry.Lookup<T> p_215979_, List<EntryWithSource> p_215980_) {
        LinkedHashSet builder = new LinkedHashSet();
        ArrayList<EntryWithSource> list = new ArrayList<EntryWithSource>();
        for (EntryWithSource tagloader$entrywithsource : p_215980_) {
            if (tagloader$entrywithsource.entry().build(p_215979_, tagloader$entrywithsource.remove() ? builder::remove : builder::add) || tagloader$entrywithsource.remove()) continue;
            list.add(tagloader$entrywithsource);
        }
        return list.isEmpty() ? Either.right(List.copyOf(builder)) : Either.left(list);
    }

    public Map<ResourceLocation, Collection<T>> build(Map<ResourceLocation, List<EntryWithSource>> p_203899_) {
        final HashMap map = Maps.newHashMap();
        TagEntry.Lookup lookup = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation p_216039_) {
                return TagLoader.this.idToValue.apply(p_216039_).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation p_216041_) {
                return (Collection)map.get(p_216041_);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> dependencysorter = new DependencySorter<ResourceLocation, SortingEntry>();
        p_203899_.forEach((p_284685_, p_284686_) -> dependencysorter.addEntry((ResourceLocation)p_284685_, new SortingEntry((List<EntryWithSource>)p_284686_)));
        dependencysorter.orderByDependencies((p_284682_, p_284683_) -> this.build(lookup, p_284683_.entries).ifLeft(p_215977_ -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", p_284682_, (Object)p_215977_.stream().map(Objects::toString).collect(Collectors.joining(", \n\t")))).ifRight(p_216001_ -> map.put(p_284682_, p_216001_)));
        return map;
    }

    public Map<ResourceLocation, Collection<T>> loadAndBuild(ResourceManager p_203901_) {
        return this.build(this.load(p_203901_));
    }

    public record EntryWithSource(TagEntry entry, String source, boolean remove) {
        public EntryWithSource(TagEntry entry, String source) {
            this(entry, source, false);
        }

        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285529_) {
            this.entries.forEach(p_285236_ -> p_285236_.entry.visitRequiredDependencies(p_285529_));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285469_) {
            this.entries.forEach(p_284943_ -> p_284943_.entry.visitOptionalDependencies(p_285469_));
        }
    }
}

