/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;

public class TagManager
implements PreparableReloadListener {
    private final RegistryAccess registryAccess;
    private List<LoadResult<?>> results = List.of();

    public TagManager(RegistryAccess $$0) {
        this.registryAccess = $$0;
    }

    public List<LoadResult<?>> getResult() {
        return this.results;
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier $$0, ResourceManager $$12, ProfilerFiller $$22, ProfilerFiller $$3, Executor $$4, Executor $$5) {
        List<CompletableFuture> $$6 = this.registryAccess.registries().map($$2 -> this.createLoader($$12, $$4, (RegistryAccess.RegistryEntry)$$2)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])$$6.toArray(CompletableFuture[]::new)).thenCompose($$0::wait)).thenAcceptAsync($$1 -> {
            this.results = $$6.stream().map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        }, $$5);
    }

    private <T> CompletableFuture<LoadResult<T>> createLoader(ResourceManager $$0, Executor $$1, RegistryAccess.RegistryEntry<T> $$2) {
        ResourceKey $$3 = $$2.key();
        Registry<T> $$4 = $$2.value();
        TagLoader $$5 = new TagLoader($$4::getHolder, Registries.tagsDirPath($$3));
        return CompletableFuture.supplyAsync(() -> new LoadResult($$3, $$5.loadAndBuild($$0)), $$1);
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<ResourceLocation, Collection<Holder<T>>> tags) {
    }
}

