/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagKey;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends Registry<?>>, NetworkPayload> serializeTagsToNetwork(LayeredRegistryAccess<RegistryLayer> $$02) {
        return RegistrySynchronization.networkSafeRegistries($$02).map($$0 -> Pair.of($$0.key(), (Object)TagNetworkSerialization.serializeToNetwork($$0.value()))).filter($$0 -> ((NetworkPayload)$$0.getSecond()).size() > 0).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> NetworkPayload serializeToNetwork(Registry<T> $$0) {
        HashMap<ResourceLocation, IntList> $$1 = new HashMap<ResourceLocation, IntList>();
        $$0.getTags().forEach($$2 -> {
            HolderSet $$3 = (HolderSet)$$2.getSecond();
            IntArrayList $$4 = new IntArrayList($$3.size());
            for (Holder $$5 : $$3) {
                if ($$5.kind() != Holder.Kind.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + String.valueOf($$5));
                }
                $$4.add($$0.getId($$5.value()));
            }
            $$1.put(((TagKey)$$2.getFirst()).location(), (IntList)$$4);
        });
        return new NetworkPayload($$1);
    }

    static <T> void deserializeTagsFromNetwork(ResourceKey<? extends Registry<T>> $$0, Registry<T> $$1, NetworkPayload $$2, TagOutput<T> $$32) {
        $$2.tags.forEach(($$3, $$4) -> {
            TagKey $$5 = TagKey.create($$0, $$3);
            List $$6 = $$4.intStream().mapToObj($$1::getHolder).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
            $$32.accept($$5, $$6);
        });
    }

    public static final class NetworkPayload {
        final Map<ResourceLocation, IntList> tags;

        NetworkPayload(Map<ResourceLocation, IntList> $$0) {
            this.tags = $$0;
        }

        public void write(FriendlyByteBuf $$0) {
            $$0.writeMap(this.tags, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeIntIdList);
        }

        public static NetworkPayload read(FriendlyByteBuf $$0) {
            return new NetworkPayload($$0.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readIntIdList));
        }

        public int size() {
            return this.tags.size();
        }

        public <T> void applyToRegistry(Registry<T> $$0) {
            if (this.size() == 0) {
                return;
            }
            HashMap $$1 = new HashMap(this.size());
            TagNetworkSerialization.deserializeTagsFromNetwork($$0.key(), $$0, this, $$1::put);
            $$0.bindTags($$1);
        }
    }

    @FunctionalInterface
    public static interface TagOutput<T> {
        public void accept(TagKey<T> var1, List<Holder<T>> var2);
    }
}

