/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public final class WolfVariant {
    public static final Codec<WolfVariant> DIRECT_CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)ResourceLocation.CODEC.fieldOf("wild_texture").forGetter($$0 -> $$0.wildTexture), (App)ResourceLocation.CODEC.fieldOf("tame_texture").forGetter($$0 -> $$0.tameTexture), (App)ResourceLocation.CODEC.fieldOf("angry_texture").forGetter($$0 -> $$0.angryTexture), (App)RegistryCodecs.homogeneousList(Registries.BIOME).fieldOf("biomes").forGetter(WolfVariant::biomes)).apply((Applicative)$$02, WolfVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WolfVariant> DIRECT_STREAM_CODEC = StreamCodec.composite(ResourceLocation.STREAM_CODEC, WolfVariant::wildTexture, ResourceLocation.STREAM_CODEC, WolfVariant::tameTexture, ResourceLocation.STREAM_CODEC, WolfVariant::angryTexture, ByteBufCodecs.holderSet(Registries.BIOME), WolfVariant::biomes, WolfVariant::new);
    public static final Codec<Holder<WolfVariant>> CODEC = RegistryFileCodec.create(Registries.WOLF_VARIANT, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<WolfVariant>> STREAM_CODEC = ByteBufCodecs.holder(Registries.WOLF_VARIANT, DIRECT_STREAM_CODEC);
    private final ResourceLocation wildTexture;
    private final ResourceLocation tameTexture;
    private final ResourceLocation angryTexture;
    private final ResourceLocation wildTextureFull;
    private final ResourceLocation tameTextureFull;
    private final ResourceLocation angryTextureFull;
    private final HolderSet<Biome> biomes;

    public WolfVariant(ResourceLocation $$0, ResourceLocation $$1, ResourceLocation $$2, HolderSet<Biome> $$3) {
        this.wildTexture = $$0;
        this.wildTextureFull = WolfVariant.fullTextureId($$0);
        this.tameTexture = $$1;
        this.tameTextureFull = WolfVariant.fullTextureId($$1);
        this.angryTexture = $$2;
        this.angryTextureFull = WolfVariant.fullTextureId($$2);
        this.biomes = $$3;
    }

    private static ResourceLocation fullTextureId(ResourceLocation $$02) {
        return $$02.withPath($$0 -> "textures/" + $$0 + ".png");
    }

    public ResourceLocation wildTexture() {
        return this.wildTextureFull;
    }

    public ResourceLocation tameTexture() {
        return this.tameTextureFull;
    }

    public ResourceLocation angryTexture() {
        return this.angryTextureFull;
    }

    public HolderSet<Biome> biomes() {
        return this.biomes;
    }

    public boolean equals(Object $$0) {
        if ($$0 == this) {
            return true;
        }
        if ($$0 instanceof WolfVariant) {
            WolfVariant $$1 = (WolfVariant)$$0;
            return Objects.equals(this.wildTexture, $$1.wildTexture) && Objects.equals(this.tameTexture, $$1.tameTexture) && Objects.equals(this.angryTexture, $$1.angryTexture) && Objects.equals(this.biomes, $$1.biomes);
        }
        return false;
    }

    public int hashCode() {
        int $$0 = 1;
        $$0 = 31 * $$0 + this.wildTexture.hashCode();
        $$0 = 31 * $$0 + this.tameTexture.hashCode();
        $$0 = 31 * $$0 + this.angryTexture.hashCode();
        $$0 = 31 * $$0 + this.biomes.hashCode();
        return $$0;
    }
}

