/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class Arrow
extends AbstractArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.defineId(Arrow.class, EntityDataSerializers.INT);
    private static final byte EVENT_POTION_PUFF = 0;

    public Arrow(EntityType<? extends Arrow> $$0, Level $$1) {
        super((EntityType<? extends AbstractArrow>)$$0, $$1);
    }

    public Arrow(Level $$0, double $$1, double $$2, double $$3, ItemStack $$4, @Nullable ItemStack $$5) {
        super(EntityType.ARROW, $$1, $$2, $$3, $$0, $$4, $$5);
        this.updateColor();
    }

    public Arrow(Level $$0, LivingEntity $$1, ItemStack $$2, @Nullable ItemStack $$3) {
        super(EntityType.ARROW, $$1, $$0, $$2, $$3);
        this.updateColor();
    }

    private PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
    }

    private void setPotionContents(PotionContents $$0) {
        this.getPickupItemStackOrigin().set(DataComponents.POTION_CONTENTS, $$0);
        this.updateColor();
    }

    @Override
    protected void setPickupItemStack(ItemStack $$0) {
        super.setPickupItemStack($$0);
        this.updateColor();
    }

    private void updateColor() {
        PotionContents $$0 = this.getPotionContents();
        this.entityData.set(ID_EFFECT_COLOR, $$0.equals(PotionContents.EMPTY) ? -1 : $$0.getColor());
    }

    public void addEffect(MobEffectInstance $$0) {
        this.setPotionContents(this.getPotionContents().withEffectAdded($$0));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        super.defineSynchedData($$0);
        $$0.define(ID_EFFECT_COLOR, -1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.getPotionContents().equals(PotionContents.EMPTY) && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent(this, (byte)0);
            this.setPickupItemStack(new ItemStack(Items.ARROW));
        }
    }

    private void makeParticle(int $$0) {
        int $$1 = this.getColor();
        if ($$1 == -1 || $$0 <= 0) {
            return;
        }
        for (int $$2 = 0; $$2 < $$0; ++$$2) {
            this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, $$1), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    public int getColor() {
        return this.entityData.get(ID_EFFECT_COLOR);
    }

    @Override
    protected void doPostHurtEffects(LivingEntity $$02) {
        super.doPostHurtEffects($$02);
        Entity $$1 = this.getEffectSource();
        PotionContents $$2 = this.getPotionContents();
        if ($$2.potion().isPresent()) {
            for (MobEffectInstance $$3 : $$2.potion().get().value().getEffects()) {
                $$02.addEffect(new MobEffectInstance($$3.getEffect(), Math.max($$3.mapDuration($$0 -> $$0 / 8), 1), $$3.getAmplifier(), $$3.isAmbient(), $$3.isVisible()), $$1);
            }
        }
        for (MobEffectInstance $$4 : $$2.customEffects()) {
            $$02.addEffect($$4, $$1);
        }
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.ARROW);
    }

    @Override
    public void handleEntityEvent(byte $$0) {
        if ($$0 == 0) {
            int $$1 = this.getColor();
            if ($$1 != -1) {
                float $$2 = (float)($$1 >> 16 & 0xFF) / 255.0f;
                float $$3 = (float)($$1 >> 8 & 0xFF) / 255.0f;
                float $$4 = (float)($$1 >> 0 & 0xFF) / 255.0f;
                for (int $$5 = 0; $$5 < 20; ++$$5) {
                    this.level().addParticle(ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, $$2, $$3, $$4), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            super.handleEntityEvent($$0);
        }
    }
}

