/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.FLOAT);

    public VehicleEntity(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Override
    public boolean hurt(DamageSource $$0, float $$1) {
        boolean $$2;
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo($$0)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + $$1 * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, $$0.getEntity());
        boolean bl = $$2 = $$0.getEntity() instanceof Player && ((Player)$$0.getEntity()).getAbilities().instabuild;
        if (!$$2 && this.getDamage() > 40.0f || this.shouldSourceDestroy($$0)) {
            this.destroy($$0);
        } else if ($$2) {
            this.discard();
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource $$0) {
        return false;
    }

    public void destroy(Item $$0) {
        this.kill();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        ItemStack $$1 = new ItemStack($$0);
        $$1.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.spawnAtLocation($$1);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        $$0.define(DATA_ID_HURT, 0);
        $$0.define(DATA_ID_HURTDIR, 1);
        $$0.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int $$0) {
        this.entityData.set(DATA_ID_HURT, $$0);
    }

    public void setHurtDir(int $$0) {
        this.entityData.set(DATA_ID_HURTDIR, $$0);
    }

    public void setDamage(float $$0) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf($$0));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource $$0) {
        this.destroy(this.getDropItem());
    }

    abstract Item getDropItem();
}

