/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.Provider registries;
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    private Map<ResourceLocation, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;
    private final ICondition.IContext context;

    public RecipeManager(HolderLookup.Provider p_330459_) {
        this(p_330459_, ICondition.IContext.EMPTY);
    }

    public RecipeManager(HolderLookup.Provider p_330459_, ICondition.IContext context) {
        super(GSON, Registries.elementsDirPath(Registries.RECIPE));
        this.registries = p_330459_;
        this.context = context;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        RegistryOps registryops = (RegistryOps)this.registries.createSerializationContext(JsonOps.INSTANCE).withContext(ICondition.IContext.KEY, this.context);
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_44037_.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.getPath().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !ForgeHooks.readAndTestCondition((RegistryOps)registryops, (JsonObject)entry.getValue().getAsJsonObject())) {
                    LOGGER.debug("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                Recipe recipe = (Recipe)Recipe.CODEC.parse((DynamicOps)registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<Recipe> recipeholder = new RecipeHolder<Recipe>(resourcelocation, recipe);
                builder.put(recipe.getType(), recipeholder);
                builder1.put((Object)resourcelocation, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.byType = builder.build();
        this.byName = builder1.build();
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_44016_, I p_344358_, Level p_44018_) {
        return this.getRecipeFor(p_44016_, p_344358_, p_44018_, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_220249_, I p_344518_, Level p_220251_, @Nullable ResourceLocation p_220252_) {
        RecipeHolder<T> recipeholder = p_220252_ != null ? this.byKeyTyped(p_220249_, p_220252_) : null;
        return this.getRecipeFor(p_220249_, p_344518_, p_220251_, recipeholder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> p_343647_, I p_342793_, Level p_344483_, @Nullable RecipeHolder<T> p_345187_) {
        if (p_342793_.isEmpty()) {
            return Optional.empty();
        }
        return p_345187_ != null && p_345187_.value().matches(p_342793_, p_344483_) ? Optional.of(p_345187_) : this.byType(p_343647_).stream().filter(p_341585_ -> p_341585_.value().matches((RecipeInput)p_342793_, p_344483_)).findFirst();
    }

    public <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getAllRecipesFor(RecipeType<T> p_44014_) {
        return List.copyOf(this.byType(p_44014_));
    }

    public <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> p_44057_, I p_345126_, Level p_44059_) {
        return this.byType(p_44057_).stream().filter(p_341582_ -> p_341582_.value().matches((RecipeInput)p_345126_, p_44059_)).sorted(Comparator.comparing(p_327196_ -> p_327196_.value().getResultItem(p_44059_.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> p_44055_) {
        return this.byType.get(p_44055_);
    }

    public <I extends RecipeInput, T extends Recipe<I>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> p_44070_, I p_345480_, Level p_44072_) {
        Optional<RecipeHolder<T>> optional = this.getRecipeFor(p_44070_, p_345480_, p_44072_);
        if (optional.isPresent()) {
            return optional.get().value().getRemainingItems(p_345480_);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_345480_.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, p_345480_.getItem(i));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> byKey(ResourceLocation p_44044_) {
        return Optional.ofNullable(this.byName.get(p_44044_));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> p_332930_, ResourceLocation p_335282_) {
        RecipeHolder<?> recipeholder = this.byName.get(p_335282_);
        return recipeholder != null && recipeholder.value().getType().equals(p_332930_) ? recipeholder : null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<ResourceLocation> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceLocation p_44046_, JsonObject p_44047_, HolderLookup.Provider p_328308_) {
        Recipe recipe = (Recipe)Recipe.CODEC.parse(p_328308_.createSerializationContext(JsonOps.INSTANCE), (Object)p_44047_).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(p_44046_, recipe);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> p_44025_) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : p_44025_) {
            RecipeType<?> recipetype = recipeholder.value().getType();
            builder.put(recipetype, recipeholder);
            builder1.put((Object)recipeholder.id(), recipeholder);
        }
        this.byType = builder.build();
        this.byName = builder1.build();
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> p_220268_) {
        return new CachedCheck<I, T>(){
            @Nullable
            private ResourceLocation lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I p_343525_, Level p_220279_) {
                RecipeManager recipemanager = p_220279_.getRecipeManager();
                Optional optional = recipemanager.getRecipeFor(p_220268_, p_343525_, p_220279_, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, Level var2);
    }
}

