/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;

public abstract class SingleItemRecipe
implements Recipe<SingleRecipeInput> {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final String group;

    public SingleItemRecipe(RecipeType<?> $$0, RecipeSerializer<?> $$1, String $$2, Ingredient $$3, ItemStack $$4) {
        this.type = $$0;
        this.serializer = $$1;
        this.group = $$2;
        this.ingredient = $$3;
        this.result = $$4;
    }

    @Override
    public RecipeType<?> getType() {
        return this.type;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider $$0) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        NonNullList<Ingredient> $$0 = NonNullList.create();
        $$0.add(this.ingredient);
        return $$0;
    }

    @Override
    public boolean canCraftInDimensions(int $$0, int $$1) {
        return true;
    }

    @Override
    public ItemStack assemble(SingleRecipeInput $$0, HolderLookup.Provider $$1) {
        return this.result.copy();
    }

    public static interface Factory<T extends SingleItemRecipe> {
        public T create(String var1, Ingredient var2, ItemStack var3);
    }

    public static class Serializer<T extends SingleItemRecipe>
    implements RecipeSerializer<T> {
        final Factory<T> factory;
        private final MapCodec<T> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

        protected Serializer(Factory<T> $$02) {
            this.factory = $$02;
            this.codec = RecordCodecBuilder.mapCodec($$1 -> $$1.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter($$0 -> $$0.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter($$0 -> $$0.ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter($$0 -> $$0.result)).apply((Applicative)$$1, $$02::create));
            this.streamCodec = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, $$0 -> $$0.group, Ingredient.CONTENTS_STREAM_CODEC, $$0 -> $$0.ingredient, ItemStack.STREAM_CODEC, $$0 -> $$0.result, $$02::create);
        }

        @Override
        public MapCodec<T> codec() {
            return this.codec;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }
}

