/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CherryLeavesBlock
extends LeavesBlock {
    public static final MapCodec<CherryLeavesBlock> CODEC = CherryLeavesBlock.simpleCodec(CherryLeavesBlock::new);

    public MapCodec<CherryLeavesBlock> codec() {
        return CODEC;
    }

    public CherryLeavesBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    @Override
    public void animateTick(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        super.animateTick($$0, $$1, $$2, $$3);
        if ($$3.nextInt(10) != 0) {
            return;
        }
        BlockPos $$4 = $$2.below();
        BlockState $$5 = $$1.getBlockState($$4);
        if (CherryLeavesBlock.isFaceFull($$5.getCollisionShape($$1, $$4), Direction.UP)) {
            return;
        }
        ParticleUtils.spawnParticleBelow($$1, $$2, $$3, ParticleTypes.CHERRY_LEAVES);
    }
}

