/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import java.util.concurrent.atomic.AtomicLong;

public final class RandomSupport {
    public static final long GOLDEN_RATIO_64 = -7046029254386353131L;
    public static final long SILVER_RATIO_64 = 7640891576956012809L;
    private static final HashFunction MD5_128 = Hashing.md5();
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);

    @VisibleForTesting
    public static long mixStafford13(long $$0) {
        $$0 = ($$0 ^ $$0 >>> 30) * -4658895280553007687L;
        $$0 = ($$0 ^ $$0 >>> 27) * -7723592293110705685L;
        return $$0 ^ $$0 >>> 31;
    }

    public static Seed128bit upgradeSeedTo128bitUnmixed(long $$0) {
        long $$1 = $$0 ^ 0x6A09E667F3BCC909L;
        long $$2 = $$1 + -7046029254386353131L;
        return new Seed128bit($$1, $$2);
    }

    public static Seed128bit upgradeSeedTo128bit(long $$0) {
        return RandomSupport.upgradeSeedTo128bitUnmixed($$0).mixed();
    }

    public static Seed128bit seedFromHashOf(String $$0) {
        byte[] $$1 = MD5_128.hashString((CharSequence)$$0, Charsets.UTF_8).asBytes();
        long $$2 = Longs.fromBytes((byte)$$1[0], (byte)$$1[1], (byte)$$1[2], (byte)$$1[3], (byte)$$1[4], (byte)$$1[5], (byte)$$1[6], (byte)$$1[7]);
        long $$3 = Longs.fromBytes((byte)$$1[8], (byte)$$1[9], (byte)$$1[10], (byte)$$1[11], (byte)$$1[12], (byte)$$1[13], (byte)$$1[14], (byte)$$1[15]);
        return new Seed128bit($$2, $$3);
    }

    public static long generateUniqueSeed() {
        return SEED_UNIQUIFIER.updateAndGet($$0 -> $$0 * 1181783497276652981L) ^ System.nanoTime();
    }

    public record Seed128bit(long seedLo, long seedHi) {
        public Seed128bit xor(long $$0, long $$1) {
            return new Seed128bit(this.seedLo ^ $$0, this.seedHi ^ $$1);
        }

        public Seed128bit xor(Seed128bit $$0) {
            return this.xor($$0.seedLo, $$0.seedHi);
        }

        public Seed128bit mixed() {
            return new Seed128bit(RandomSupport.mixStafford13(this.seedLo), RandomSupport.mixStafford13(this.seedHi));
        }
    }
}

